/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.html.NullLocalNameMembrane;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import java.util.Arrays;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class NodesTest
extends CajaTestCase {
    public final void testDecode() {
        NodesTest.assertEquals((String)Nodes.decode("1 &lt; 2 &amp;&amp; 4 &gt; &quot;3&quot;"), (String)"1 < 2 && 4 > \"3\"");
        NodesTest.assertEquals((String)"", (String)Nodes.decode(""));
        NodesTest.assertEquals((String)"No entities here", (String)Nodes.decode("No entities here"));
        NodesTest.assertEquals((String)"No entities here & there", (String)Nodes.decode("No entities here & there"));
        NodesTest.assertEquals((String)"\\\\u000a", (String)Nodes.decode("\\\\u000a"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#x00000a;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#x0000a;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#x000a;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#x00a;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#x0a;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#xa;"));
        NodesTest.assertEquals((String)String.valueOf(Character.toChars(65536)), (String)Nodes.decode("&#x10000;"));
        NodesTest.assertEquals((String)"&#xa", (String)Nodes.decode("&#xa"));
        NodesTest.assertEquals((String)"&#x00ziggy", (String)Nodes.decode("&#x00ziggy"));
        NodesTest.assertEquals((String)"&#xa00z;", (String)Nodes.decode("&#xa00z;"));
        NodesTest.assertEquals((String)"&#\n", (String)Nodes.decode("&#&#x000a;"));
        NodesTest.assertEquals((String)"&#x\n", (String)Nodes.decode("&#x&#x000a;"));
        NodesTest.assertEquals((String)"&#xa\n", (String)Nodes.decode("&#xa&#x000a;"));
        NodesTest.assertEquals((String)"&#\n", (String)Nodes.decode("&#&#xa;"));
        NodesTest.assertEquals((String)"&#x", (String)Nodes.decode("&#x"));
        NodesTest.assertEquals((String)"&#x0", (String)Nodes.decode("&#x0"));
        NodesTest.assertEquals((String)"&#", (String)Nodes.decode("&#"));
        NodesTest.assertEquals((String)"\\", (String)Nodes.decode("\\"));
        NodesTest.assertEquals((String)"&", (String)Nodes.decode("&"));
        NodesTest.assertEquals((String)"&#000a;", (String)Nodes.decode("&#000a;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#10;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#010;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#0010;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#00010;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#000010;"));
        NodesTest.assertEquals((String)"\n", (String)Nodes.decode("&#0000010;"));
        NodesTest.assertEquals((String)"\t", (String)Nodes.decode("&#9;"));
        NodesTest.assertEquals((String)"&#10", (String)Nodes.decode("&#10"));
        NodesTest.assertEquals((String)"&#00ziggy", (String)Nodes.decode("&#00ziggy"));
        NodesTest.assertEquals((String)"&#\n", (String)Nodes.decode("&#&#010;"));
        NodesTest.assertEquals((String)"&#0\n", (String)Nodes.decode("&#0&#010;"));
        NodesTest.assertEquals((String)"&#01\n", (String)Nodes.decode("&#01&#10;"));
        NodesTest.assertEquals((String)"&#\n", (String)Nodes.decode("&#&#10;"));
        NodesTest.assertEquals((String)"&#1", (String)Nodes.decode("&#1"));
        NodesTest.assertEquals((String)"&#10", (String)Nodes.decode("&#10"));
        NodesTest.assertEquals((String)"<", (String)Nodes.decode("&lt;"));
        NodesTest.assertEquals((String)">", (String)Nodes.decode("&gt;"));
        NodesTest.assertEquals((String)"\"", (String)Nodes.decode("&quot;"));
        NodesTest.assertEquals((String)"'", (String)Nodes.decode("&apos;"));
        NodesTest.assertEquals((String)"&", (String)Nodes.decode("&amp;"));
        NodesTest.assertEquals((String)"&lt;", (String)Nodes.decode("&amp;lt;"));
        NodesTest.assertEquals((String)"&", (String)Nodes.decode("&AMP;"));
        NodesTest.assertEquals((String)"&AMP", (String)Nodes.decode("&AMP"));
        NodesTest.assertEquals((String)"&", (String)Nodes.decode("&AmP;"));
        NodesTest.assertEquals((String)"\u0391", (String)Nodes.decode("&Alpha;"));
        NodesTest.assertEquals((String)"\u03b1", (String)Nodes.decode("&alpha;"));
        NodesTest.assertEquals((String)"&;", (String)Nodes.decode("&;"));
        NodesTest.assertEquals((String)"&bogus;", (String)Nodes.decode("&bogus;"));
    }

    public final void testRenderOfEmbeddedXml() throws Exception {
        NodesTest.assertEquals((String)"<td width=\"10\"><svg:Rect width=\"50\"></svg:Rect></td>", (String)Nodes.render((Node)this.xmlFragment(this.fromString("<html:td width='10'><svg:Rect width='50'/></html:td>")), false));
        NodesTest.assertEquals((String)"<td width=\"10\"><svg:Rect width=\"50\" /></td>", (String)Nodes.render((Node)this.xmlFragment(this.fromString("<html:td width='10'><svg:Rect width='50'/></html:td>")), true));
    }

    public final void testRenderWithNonstandardNamespaces() throws Exception {
        NodesTest.assertEquals((String)"<td width=\"10\"><svg:Rect width=\"50\" /></td>", (String)Nodes.render((Node)this.xmlFragment(this.fromString("<html:td width='10' xmlns:s='http://www.w3.org/2000/svg'><s:Rect width='50'/></html:td>")), true));
    }

    public final void testRenderWithUnknownNamespace() throws Exception {
        NodesTest.assertEquals((String)"<xml:foo><_ns1:baz xmlns:_ns1=\"http://bobs.house.of/XML&amp;BBQ\" boo=\"howdy\" xml:lang=\"es\" /></xml:foo>", (String)Nodes.render((Node)this.xmlFragment(this.fromString("<foo xmlns='http://www.w3.org/XML/1998/namespace' xmlns:bar='http://bobs.house.of/XML&BBQ'><bar:baz boo='howdy' xml:lang='es'/></foo>")), true));
    }

    public final void testRenderWithMaskedInputNamespace1() throws Exception {
        DocumentFragment fragment = this.xmlFragment(this.fromString("<svg:foo><svg:bar xmlns:svg='http://www.w3.org/1999/xhtml'/></svg:foo>"));
        NodesTest.assertEquals((String)"<svg:foo><bar></bar></svg:foo>", (String)Nodes.render(fragment));
    }

    public final void testRenderWithMaskedInputNamespace2() throws Exception {
        DocumentFragment fragment = this.xmlFragment(this.fromString("<svg:foo><svg:bar xmlns:svg='http://foo/'/></svg:foo>"));
        NodesTest.assertEquals((String)"<svg:foo><_ns1:bar xmlns:_ns1=\"http://foo/\"></_ns1:bar></svg:foo>", (String)Nodes.render(fragment));
    }

    public final void testRenderWithMaskedOutputNamespace1() throws Exception {
        DocumentFragment fragment = this.xmlFragment(this.fromString("<svg:foo><xml:bar/></svg:foo>"));
        Namespaces ns = new Namespaces(Namespaces.HTML_DEFAULT, "svg", "http://www.w3.org/XML/1998/namespace");
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(new Concatenator(sb)).withMarkupRenderMode(MarkupRenderMode.XML);
        Nodes.render(fragment, ns, rc);
        rc.getOut().noMoreTokens();
        NodesTest.assertEquals((String)"<_ns2:foo xmlns:_ns2=\"http://www.w3.org/2000/svg\"><svg:bar /></_ns2:foo>", (String)sb.toString());
    }

    public final void testHtmlNamesNormalized() throws Exception {
        Document doc = DomParser.makeDocument(null, null);
        Element el = doc.createElementNS("http://www.w3.org/1999/xhtml", "SPAN");
        el.setAttributeNS("http://www.w3.org/1999/xhtml", "TITLE", "Howdy");
        NodesTest.assertEquals((String)"<span title=\"Howdy\"></span>", (String)Nodes.render(el));
        Namespaces ns = new Namespaces(Namespaces.HTML_DEFAULT, "html", "http://www.w3.org/1999/xhtml");
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(new Concatenator(sb)).withMarkupRenderMode(MarkupRenderMode.HTML);
        Nodes.render(el, ns, rc);
        rc.getOut().noMoreTokens();
        NodesTest.assertEquals((String)"<html:span title=\"Howdy\"></html:span>", (String)sb.toString());
    }

    public final void testNoSneakyNamespaceDecls1() throws Exception {
        String rendered;
        Document doc = DomParser.makeDocument(null, null);
        Element el = doc.createElementNS("http://www.w3.org/2000/svg", "span");
        try {
            el.setAttributeNS("http://www.w3.org/2000/svg", "xmlns", "http://www.w3.org/1999/xhtml");
        }
        catch (Exception ex) {
            try {
                el.setAttributeNS("http://www.w3.org/1999/xhtml", "xmlns", "http://www.w3.org/1999/xhtml");
            }
            catch (Exception ex2) {
                el.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            }
        }
        el.appendChild(doc.createElementNS("http://www.w3.org/2000/svg", "br"));
        try {
            rendered = Nodes.render(el);
        }
        catch (RuntimeException ex) {
            return;
        }
        NodesTest.assertEquals((String)"<svg:span><svg:br/></svg:span>", (String)rendered);
    }

    public final void testNoSneakyNamespaceDecls2() throws Exception {
        String rendered;
        Document doc = DomParser.makeDocument(null, null);
        Element el = doc.createElementNS("http://www.w3.org/2000/svg", "span");
        try {
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", "svg", "http://www.w3.org/1999/xhtml");
        }
        catch (Exception ex) {
            try {
                el.setAttributeNS("http://www.w3.org/1999/xhtml", "xmlns:svg", "http://www.w3.org/1999/xhtml");
            }
            catch (Exception ex2) {
                el.setAttribute("xmlns:svg", "http://www.w3.org/1999/xhtml");
            }
        }
        el.appendChild(doc.createElementNS("http://www.w3.org/2000/svg", "br"));
        try {
            rendered = Nodes.render(el);
        }
        catch (RuntimeException ex) {
            return;
        }
        NodesTest.assertEquals((String)"<svg:span><svg:br/></svg:span>", (String)rendered);
    }

    public final void testProcessingInstructions() {
        Document doc = DomParser.makeDocument(null, null);
        ProcessingInstruction pi = doc.createProcessingInstruction("foo", "bar");
        NodesTest.assertEquals((String)"<?foo bar?>", (String)Nodes.render((Node)pi, true));
    }

    public final void testBadProcessingInstructions() {
        Document doc = DomParser.makeDocument(null, null);
        for (Object[] objectArray : new String[][]{{"xml", "foo"}, {"XmL", "foo"}, {"foo?><script>alert(1)</script>", "<?bar baz"}, {"ok", "foo?><script>alert(1)</script><?foo bar"}}) {
            try {
                ProcessingInstruction pi = doc.createProcessingInstruction(objectArray[0], objectArray[1]);
                Nodes.render((Node)pi, true);
            }
            catch (IllegalStateException ex) {
                continue;
            }
            catch (DOMException ex) {
                continue;
            }
            NodesTest.fail((String)("Rendered " + Arrays.toString(objectArray)));
        }
    }

    public final void testProcessingInstructionInHtml() {
        Document doc = DomParser.makeDocument(null, null);
        ProcessingInstruction pi = doc.createProcessingInstruction("foo", "<script>alert(1)</script>");
        Element el = doc.createElementNS("http://www.w3.org/1999/xhtml", "div");
        el.appendChild(pi);
        NodesTest.assertEquals((String)"<div><?foo <script>alert(1)</script>?></div>", (String)Nodes.render((Node)el, true));
        try {
            Nodes.render((Node)el, false);
        }
        catch (IllegalStateException ex) {
            return;
        }
        NodesTest.fail((String)"Rendered in html");
    }

    public final void testRenderWithBrokenNekoDom() throws Exception {
        Element el = this.html(this.fromString("<a href='foo.html'>bar</a>"));
        NodesTest.assertEquals((String)"<html><head></head><body><a href=\"foo.html\">bar</a></body></html>", (String)Nodes.render(new NullLocalNameMembrane().wrap(el, Element.class)));
    }

    public final void testRenderModes() throws Exception {
        DocumentFragment f = this.htmlFragment(this.fromString("<input checked name=foo type=checkbox>"));
        NodesTest.assertEquals((String)"<input checked=\"checked\" name=\"foo\" type=\"checkbox\" />", (String)Nodes.render((Node)f, MarkupRenderMode.XML));
        NodesTest.assertEquals((String)"<input checked=\"checked\" name=\"foo\" type=\"checkbox\" />", (String)Nodes.render((Node)f, MarkupRenderMode.HTML));
        NodesTest.assertEquals((String)"<input checked name=\"foo\" type=\"checkbox\">", (String)Nodes.render((Node)f, MarkupRenderMode.HTML4_BACKWARDS_COMPAT));
    }

    public final void testRenderSpeed() throws Exception {
        Element doc = this.html(this.fromResource("amazon.com.html"));
        this.benchmark(100, doc);
        Thread.sleep(250L);
        int microsPerRun = this.benchmark(250, doc);
        System.out.println(" VarZ:" + ((Object)((Object)this)).getClass().getName() + ".msPerRun=" + microsPerRun);
    }

    private int benchmark(int nRuns, Element el) {
        long t0 = System.nanoTime();
        int i = nRuns;
        while (--i >= 0) {
            Nodes.render(el);
        }
        return (int)((double)(System.nanoTime() - t0) / (double)nRuns / 1000.0);
    }
}

