/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.exoplatform.web.filter.FilterDefinition;
import org.exoplatform.web.filter.FilterDefinitionPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleFilter {
    private volatile List<FilterDefinition> filters = Collections.unmodifiableList(new ArrayList());

    public void addFilterDefinitions(FilterDefinitionPlugin plugin) {
        this.addFilterDefinitions(plugin.getFilterDefinitions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFilterDefinitions(List<FilterDefinition> pluginFilters) {
        if (pluginFilters == null || pluginFilters.isEmpty()) {
            return;
        }
        ExtensibleFilter extensibleFilter = this;
        synchronized (extensibleFilter) {
            ArrayList<FilterDefinition> result = new ArrayList<FilterDefinition>(this.filters);
            result.addAll(pluginFilters);
            this.filters = Collections.unmodifiableList(result);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, String path) throws IOException, ServletException {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(chain, this.filters, path);
        efChain.doFilter(request, response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensibleFilterChain
    implements FilterChain {
        private final FilterChain parentChain;
        private final Iterator<FilterDefinition> filters;
        private final String path;

        private ExtensibleFilterChain(FilterChain parentChain, List<FilterDefinition> filters, String path_) {
            this.parentChain = parentChain;
            this.filters = filters.iterator();
            this.path = path_;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            while (this.filters.hasNext()) {
                FilterDefinition filterDef = this.filters.next();
                if (!filterDef.getMapping().match(this.path)) continue;
                filterDef.getFilter().doFilter(request, response, this);
                return;
            }
            this.parentChain.doFilter(request, response);
        }
    }
}

