/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.services.jcr.impl.InspectionLog;

public class InspectionLogWriter
implements InspectionLog {
    private static final String LINE_COMMENT = "//";
    private static final String LINE_DELIMITER = "\n";
    private static final String WSP = " ";
    private final Writer out;
    private final Set<InspectionLog.InspectionStatus> statusSet = new HashSet<InspectionLog.InspectionStatus>();

    public InspectionLogWriter(Writer out) {
        this.out = out;
    }

    public boolean hasInconsistency() {
        return this.statusSet.contains((Object)InspectionLog.InspectionStatus.ERR) || this.statusSet.contains((Object)InspectionLog.InspectionStatus.REINDEX);
    }

    public boolean hasWarnings() {
        return this.statusSet.contains((Object)InspectionLog.InspectionStatus.WARN);
    }

    public void logComment(String message) throws IOException {
        this.writeLine(message);
        this.out.flush();
    }

    public void logInspectionDescription(String description) throws IOException {
        this.writeLine(description);
        this.out.flush();
    }

    public void logBrokenObjectInfo(String brokenObjectDesc, String comment, InspectionLog.InspectionStatus status) throws IOException {
        this.statusSet.add(status);
        this.out.write(status.toString());
        this.out.write(WSP);
        this.out.write(brokenObjectDesc);
        this.out.write(WSP);
        this.out.write(comment);
        this.out.write(LINE_DELIMITER);
        this.out.flush();
    }

    public void logException(String message, Exception ex) throws IOException {
        this.statusSet.add(InspectionLog.InspectionStatus.ERR);
        this.writeLine(message);
        this.writeStackTrace(ex);
        this.out.flush();
    }

    private void writeLine(String message) throws IOException {
        this.out.write(LINE_COMMENT);
        this.out.write(message);
        this.out.write(LINE_DELIMITER);
    }

    private void writeStackTrace(Throwable e) throws IOException {
        this.writeLine(e.getMessage());
        this.writeLine(e.toString());
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            this.writeLine("\tat " + trace[i]);
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            this.writeLine("Cause:");
            this.writeStackTrace(ourCause);
        }
    }
}

