/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.services.jcr.ext.replication.transport.AbstractPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packet
extends AbstractPacket
implements Externalizable {
    private static final long serialVersionUID = -238898618077133064L;
    public static final int MAX_PACKET_SIZE = 16384;
    private byte[] buffer;
    private long size;
    private int type;
    private long offset;
    private String identifier;
    private String ownName = new String(" ");
    private Calendar timeStamp = Calendar.getInstance();
    private String fileName = new String(" ");
    private String systemId = new String(" ");
    private List<String> fileNameList = new ArrayList<String>();
    private long totalPacketCount = 1L;

    public Packet() {
    }

    public Packet(int type, String identifier, long totalPacketCount, long size, long offset, byte[] buf) {
        this.identifier = identifier;
        this.type = type;
        this.totalPacketCount = totalPacketCount;
        this.size = size;
        this.offset = offset;
        this.buffer = buf;
    }

    public Packet(int type, String identifier) {
        this.type = type;
        this.identifier = identifier;
        this.buffer = new byte[1];
    }

    public Packet(int type, String identifier, String ownName) {
        this.type = type;
        this.identifier = identifier;
        this.buffer = new byte[1];
        this.ownName = ownName;
    }

    public Packet(int type, String systemId, String identifier, String ownName, String fileName, long totalPacketCount, long offset, byte[] data) {
        this(type, identifier, ownName);
        this.fileName = fileName;
        this.systemId = systemId;
        this.totalPacketCount = totalPacketCount;
        this.offset = offset;
        this.buffer = data;
    }

    public Packet(int type, String identifier, String ownName, List<String> fileNameList) {
        this(type, identifier, ownName);
        this.fileNameList = fileNameList;
    }

    public Packet(int type, String identifier, String ownName, Calendar timeStamp) {
        this(type, identifier, ownName);
        this.timeStamp = timeStamp;
    }

    public Packet(int type, String ownName, long size, String identifier) {
        this(type, identifier, ownName);
        this.size = size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.buffer.length);
        out.write(this.buffer);
        out.writeLong(this.size);
        out.writeInt(this.type);
        out.writeLong(this.offset);
        out.writeLong(this.totalPacketCount);
        byte[] id = this.identifier.getBytes("UTF-8");
        out.writeInt(id.length);
        out.write(id);
        byte[] own = this.ownName.getBytes("UTF-8");
        out.writeInt(own.length);
        out.write(own);
        out.writeLong(this.timeStamp.getTimeInMillis());
        byte[] fn = this.fileName.getBytes("UTF-8");
        out.writeInt(fn.length);
        out.write(fn);
        out.writeInt(this.fileNameList.size());
        for (String fName : this.fileNameList) {
            fn = fName.getBytes("UTF-8");
            out.writeInt(fn.length);
            out.write(fn);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int bufSize = in.readInt();
        this.buffer = new byte[bufSize];
        in.readFully(this.buffer);
        this.size = in.readLong();
        this.type = in.readInt();
        this.offset = in.readLong();
        this.totalPacketCount = in.readLong();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.identifier = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.ownName = new String(buf, "UTF-8");
        this.timeStamp.setTimeInMillis(in.readLong());
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.fileName = new String(buf, "UTF-8");
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.fileNameList.add(new String(buf, "UTF-8"));
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getPacketType() {
        return this.type;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getTotalPacketCount() {
        return this.totalPacketCount;
    }

    public static byte[] getAsByteArray(Packet packet) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(packet);
        byte[] bArray = os.toByteArray();
        return bArray;
    }

    public static Packet getAsPacket(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(is);
        Packet objRead = (Packet)ois.readObject();
        return objRead;
    }

    public String getOwnerName() {
        return this.ownName;
    }

    public void setOwnName(String ownName) {
        this.ownName = ownName;
    }

    public Calendar getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Calendar timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<String> getFileNameList() {
        return this.fileNameList;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public final class PacketType {
        public static final int CHANGESLOG = 1;
        public static final int FIRST_CHANGESLOG_WITH_STREAM = 2;
        public static final int FIRST_PACKET_OF_STREAM = 3;
        public static final int PACKET_OF_STREAM = 4;
        public static final int LAST_PACKET_OF_STREAM = 5;
        public static final int LAST_CHANGESLOG_WITH_STREAM = 6;
        public static final int CHANGESLOG_FIRST_PACKET = 7;
        public static final int CHANGESLOG_MIDDLE_PACKET = 8;
        public static final int CHANGESLOG_LAST_PACKET = 9;
        public static final int CHANGESLOG_WITH_STREAM_FIRST_PACKET = 10;
        public static final int CHANGESLOG_WITH_STREAM_MIDDLE_PACKET = 11;
        public static final int CHANGESLOG_WITH_STREAM_LAST_PACKET = 12;
        public static final int ADD_OK = 13;
        public static final int GET_CHANGESLOG_UP_TO_DATE = 14;
        public static final int BINARY_FILE_PACKET = 15;
        public static final int ALL_BINARY_FILE_TRANSFERRED_OK = 18;
        public static final int ALL_CHANGESLOG_SAVED_OK = 19;
        public static final int SYNCHRONIZED_OK = 20;
        public static final int INITED_IN_CLUSTER = 21;
        public static final int ALL_INITED = 22;
        public static final int OLD_CHANGESLOG_REMOVED_OK = 23;
        public static final int NEED_TRANSFER_COUNTER = 24;
        public static final int REMOVED_OLD_CHANGESLOG_COUNTER = 25;
        public static final int MEMBER_STARTED = 26;
        public static final int BIG_PACKET = 27;
        public static final int GET_ALL_PRIORITY = 30;
        public static final int OWN_PRIORITY = 31;
        public static final int BINARY_CHANGESLOG_PACKET = 32;

        private PacketType() {
        }
    }
}

