/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.util;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.subject.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadContext {
    private static final Log log = LogFactory.getLog(ThreadContext.class);
    public static final String SECURITY_MANAGER_KEY = ThreadContext.class.getName() + "_SECURITY_MANAGER_KEY";
    public static final String SUBJECT_KEY = ThreadContext.class.getName() + "_SUBJECT_KEY";
    public static final String INET_ADDRESS_KEY = ThreadContext.class.getName() + "_INET_ADDRESS_KEY";
    protected static ThreadLocal<Map<Object, Object>> resources = new InheritableThreadLocal<Map<Object, Object>>(){

        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>();
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> parentValue) {
            if (parentValue != null) {
                return (Map)((HashMap)parentValue).clone();
            }
            return null;
        }
    };

    protected ThreadContext() {
    }

    protected static Map<Object, Object> getResources() {
        return resources.get();
    }

    public static Object get(Object key) {
        Object value;
        if (log.isTraceEnabled()) {
            String msg = "get() - in thread [" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
        if ((value = ThreadContext.getResources().get(key)) != null && log.isTraceEnabled()) {
            String msg = "Retrieved value of type [" + value.getClass().getName() + "] for key [" + key + "] " + "bound to thread [" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
        return value;
    }

    public static void put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            ThreadContext.remove(key);
            return;
        }
        ThreadContext.getResources().put(key, value);
        if (log.isTraceEnabled()) {
            String msg = "Bound value of type [" + value.getClass().getName() + "] for key [" + key + "] to thread " + "[" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
    }

    public static Object remove(Object key) {
        Object value = ThreadContext.getResources().remove(key);
        if (value != null && log.isTraceEnabled()) {
            String msg = "Removed value of type [" + value.getClass().getName() + "] for key [" + key + "]" + "from thread [" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
        return value;
    }

    public static boolean containsKey(Object key) {
        return ThreadContext.getResources().containsKey(key);
    }

    public static void clear() {
        ThreadContext.getResources().clear();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removed all ThreadContext values from thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static SecurityManager getSecurityManager() {
        return (SecurityManager)ThreadContext.get(SECURITY_MANAGER_KEY);
    }

    public static void bind(SecurityManager securityManager) {
        if (securityManager != null) {
            ThreadContext.put(SECURITY_MANAGER_KEY, securityManager);
        }
    }

    public static SecurityManager unbindSecurityManager() {
        return (SecurityManager)ThreadContext.remove(SECURITY_MANAGER_KEY);
    }

    public static Subject getSubject() {
        return (Subject)ThreadContext.get(SUBJECT_KEY);
    }

    public static void bind(Subject subject) {
        if (subject != null) {
            ThreadContext.put(SUBJECT_KEY, subject);
        }
    }

    public static Subject unbindSubject() {
        return (Subject)ThreadContext.remove(SUBJECT_KEY);
    }

    public static InetAddress getInetAddress() {
        return (InetAddress)ThreadContext.get(INET_ADDRESS_KEY);
    }

    public static void bind(InetAddress inetAddress) {
        if (inetAddress != null) {
            ThreadContext.put(INET_ADDRESS_KEY, inetAddress);
        }
    }

    public static InetAddress unbindInetAddress() {
        return (InetAddress)ThreadContext.remove(INET_ADDRESS_KEY);
    }
}

