/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.LockManager;
import org.jgroups.blocks.LockMultiLockedException;
import org.jgroups.blocks.LockNotGrantedException;
import org.jgroups.blocks.LockNotReleasedException;
import org.jgroups.blocks.TwoPhaseVotingAdapter;
import org.jgroups.blocks.TwoPhaseVotingListener;
import org.jgroups.blocks.VoteException;
import org.jgroups.blocks.VoteResponseProcessor;
import org.jgroups.blocks.VotingAdapter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class DistributedLockManager
implements TwoPhaseVotingListener,
LockManager,
VoteResponseProcessor,
MembershipListener {
    private static final int PROCESS_CONTINUE = 0;
    private static final int PROCESS_SKIP = 1;
    private static final int PROCESS_BREAK = 2;
    private static final long ACQUIRE_EXPIRATION = 5000L;
    private static final long VOTE_TIMEOUT = 10000L;
    private final HashMap preparedLocks = new HashMap();
    private final HashMap preparedReleases = new HashMap();
    private final HashMap heldLocks = new HashMap();
    private final TwoPhaseVotingAdapter votingAdapter;
    private final Object id;
    final Vector current_members = new Vector();
    protected final Log log = LogFactory.getLog(this.getClass());

    public DistributedLockManager(VotingAdapter voteChannel, Object id) {
        this(new TwoPhaseVotingAdapter(voteChannel), id);
    }

    public DistributedLockManager(TwoPhaseVotingAdapter channel, Object id) {
        this.id = id;
        this.votingAdapter = channel;
        this.votingAdapter.addListener(this);
        if (this.votingAdapter.getVoteChannel() != null) {
            this.votingAdapter.getVoteChannel().addMembershipListener(this);
            this.setInitialMembership(this.votingAdapter.getVoteChannel().getMembers());
        }
    }

    private void setInitialMembership(Collection members) {
        if (members != null) {
            this.current_members.clear();
            this.current_members.addAll(members);
        }
    }

    private boolean localLock(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            lockDecree.commit();
            if (lockDecree.managerId.equals(this.id)) {
                this.heldLocks.put(lockDecree.getKey(), lockDecree);
            }
            return true;
        }
        return localLock.requester.equals(lockDecree.requester);
    }

    private boolean canLock(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        return lock == null || lock.requester.equals(decree.requester);
    }

    private boolean canRelease(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        return lock == null || lock.requester.equals(decree.requester);
    }

    private void removeExpired(LockDecree decree) {
        LockDecree localLock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (localLock != null && !localLock.isValid()) {
            this.heldLocks.remove(localLock.getKey());
        }
    }

    private boolean localRelease(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            return true;
        }
        if (localLock.requester.equals(lockDecree.requester)) {
            this.heldLocks.remove(lockDecree.getKey());
            return true;
        }
        return false;
    }

    @Override
    public void lock(Object lockId, Object owner, int timeout) throws LockNotGrantedException, ChannelException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        boolean acquired = this.votingAdapter.vote(new AcquireLockDecree(lockId, owner, this.id), timeout);
        if (!acquired) {
            throw new LockNotGrantedException("Lock " + lockId + " cannot be granted.");
        }
    }

    @Override
    public void unlock(Object lockId, Object owner) throws LockNotReleasedException, ChannelException {
        try {
            this.unlock(lockId, owner, false, 10000L);
        }
        catch (LockMultiLockedException e) {
            this.log.error((Object)"Caught MultiLockedException but releaseMultiLocked is false", (Throwable)e);
        }
    }

    public void unlock(Object lockId, Object owner, long timeout) throws LockNotReleasedException, ChannelException {
        try {
            this.unlock(lockId, owner, false, timeout);
        }
        catch (LockMultiLockedException e) {
            this.log.error((Object)"Caught MultiLockedException but releaseMultiLocked is false", (Throwable)e);
        }
    }

    @Override
    public void unlock(Object lockId, Object owner, boolean releaseMultiLocked) throws LockNotReleasedException, ChannelException, LockMultiLockedException {
        this.unlock(lockId, owner, releaseMultiLocked, 10000L);
    }

    public void unlock(Object lockId, Object owner, boolean releaseMultiLocked, long timeout) throws LockNotReleasedException, ChannelException, LockMultiLockedException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        ReleaseLockDecree releaseLockDecree = new ReleaseLockDecree(lockId, owner, this.id);
        boolean released = false;
        if (releaseMultiLocked) {
            released = this.votingAdapter.vote(releaseLockDecree, timeout, this);
            if (releaseLockDecree.isMultipleLocked()) {
                throw new LockMultiLockedException("Lock was also locked by other DistributedLockManager(s)");
            }
        } else {
            released = this.votingAdapter.vote(releaseLockDecree, timeout);
        }
        if (!released) {
            throw new LockNotReleasedException("Lock cannot be unlocked.");
        }
    }

    private static boolean checkPrepared(HashMap preparedContainer, LockDecree requestedDecree) {
        LockDecree preparedDecree = (LockDecree)preparedContainer.get(requestedDecree.getKey());
        if (preparedDecree != null && !preparedDecree.isValid()) {
            preparedContainer.remove(preparedDecree.getKey());
            preparedDecree = null;
        }
        return preparedDecree == null || requestedDecree.requester.equals(preparedDecree.requester);
    }

    @Override
    public synchronized boolean prepare(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            AcquireLockDecree acquireDecree = (AcquireLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to acquire decree " + acquireDecree.lockId));
            }
            if (!DistributedLockManager.checkPrepared(this.preparedLocks, acquireDecree)) {
                return false;
            }
            if (this.canLock(acquireDecree)) {
                this.preparedLocks.put(acquireDecree.getKey(), acquireDecree);
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            ReleaseLockDecree releaseDecree = (ReleaseLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to release decree " + releaseDecree.lockId));
            }
            if (!DistributedLockManager.checkPrepared(this.preparedReleases, releaseDecree)) {
                return false;
            }
            if (this.canRelease(releaseDecree)) {
                this.preparedReleases.put(releaseDecree.getKey(), releaseDecree);
                return true;
            }
            return false;
        }
        if (decree instanceof MultiLockDecree) {
            LockDecree lockDecree;
            MultiLockDecree multiLockDecree = (MultiLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Marking " + multiLockDecree.getKey() + " as multilocked"));
            }
            if ((lockDecree = (LockDecree)this.heldLocks.get(multiLockDecree.getKey())) != null) {
                lockDecree.setMultipleLocked(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean commit(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Committing decree acquisition " + ((LockDecree)decree).lockId));
            }
            if (!DistributedLockManager.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return false;
            }
            if (this.localLock((LockDecree)decree)) {
                this.preparedLocks.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Committing decree release " + ((LockDecree)decree).lockId));
            }
            if (!DistributedLockManager.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return false;
            }
            if (this.localRelease((LockDecree)decree)) {
                this.preparedReleases.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        return decree instanceof MultiLockDecree;
    }

    @Override
    public synchronized void abort(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Aborting decree acquisition " + ((LockDecree)decree).lockId));
            }
            if (!DistributedLockManager.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return;
            }
            this.preparedLocks.remove(((LockDecree)decree).getKey());
        } else if (decree instanceof ReleaseLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Aborting decree release " + ((LockDecree)decree).lockId));
            }
            if (!DistributedLockManager.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return;
            }
            this.preparedReleases.remove(((LockDecree)decree).getKey());
        }
    }

    @Override
    public boolean processResponses(RspList responses, int consensusType, Object decree) throws ChannelException {
        Object unwrappedDecree;
        TwoPhaseVotingAdapter.TwoPhaseWrapper wrappedDecree;
        boolean voteResult;
        if (responses == null) {
            return false;
        }
        int totalPositiveVotes = 0;
        int totalNegativeVotes = 0;
        block4: for (int i = 0; i < responses.size(); ++i) {
            Rsp response = (Rsp)responses.elementAt(i);
            switch (this.checkResponse(response)) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    return false;
                }
                default: {
                    VotingAdapter.VoteResult result = (VotingAdapter.VoteResult)response.getValue();
                    totalPositiveVotes += result.getPositiveVotes();
                    totalNegativeVotes += result.getNegativeVotes();
                }
            }
        }
        boolean bl = voteResult = totalNegativeVotes == 0 && totalPositiveVotes > 0;
        if (decree instanceof TwoPhaseVotingAdapter.TwoPhaseWrapper && (wrappedDecree = (TwoPhaseVotingAdapter.TwoPhaseWrapper)decree).isPrepare() && (unwrappedDecree = wrappedDecree.getDecree()) instanceof ReleaseLockDecree) {
            ReleaseLockDecree releaseLockDecree = (ReleaseLockDecree)unwrappedDecree;
            LockDecree lock = null;
            lock = (LockDecree)this.heldLocks.get(releaseLockDecree.getKey());
            if (lock != null) {
                if (!voteResult && this.informLockingNodes(releaseLockDecree)) {
                    lock.setMultipleLocked(true);
                    voteResult = true;
                }
                if (lock.isMultipleLocked()) {
                    releaseLockDecree.setMultipleLocked(true);
                }
            }
        }
        return voteResult;
    }

    private int checkResponse(Rsp response) throws ChannelException {
        if (!response.wasReceived()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Response from node " + response.getSender() + " was not received."));
            }
            throw new ChannelException("Node " + response.getSender() + " failed to respond.");
        }
        if (response.wasSuspected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Node " + response.getSender() + " was suspected."));
            }
            return 1;
        }
        Object object = response.getValue();
        if (object instanceof Throwable) {
            throw new ChannelException("Node " + response.getSender() + " is faulty.");
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof VotingAdapter.VoteResult)) {
            String faultClass = object.getClass().getName();
            throw new ChannelException("Node " + response.getSender() + " generated fault (class " + faultClass + ')');
        }
        if (object instanceof VotingAdapter.FailureVoteResult) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)((VotingAdapter.FailureVoteResult)object).getReason());
            }
            return 2;
        }
        return 0;
    }

    private boolean informLockingNodes(ReleaseLockDecree releaseLockDecree) throws ChannelException {
        return this.votingAdapter.vote(new MultiLockDecree(releaseLockDecree), 10000L);
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector prev_view = new Vector(this.current_members);
        this.current_members.clear();
        this.current_members.addAll(new_view.getMembers());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("-- VIEW: " + this.current_members + ", old view: " + prev_view));
        }
        prev_view.removeAll(this.current_members);
        if (!prev_view.isEmpty()) {
            for (Object mbr : prev_view) {
                this.removeLocksHeldBy(this.preparedLocks, mbr);
                this.removeLocksHeldBy(this.preparedReleases, mbr);
                this.removeLocksHeldBy(this.heldLocks, mbr);
            }
        }
    }

    private void removeLocksHeldBy(Map lock_table, Object mbr) {
        Iterator it = lock_table.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            LockDecree val = (LockDecree)entry.getValue();
            Object holder = val.requester;
            if (holder == null || !holder.equals(mbr)) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("removing a leftover lock held by " + mbr + " for " + entry.getKey() + ": " + val));
            }
            it.remove();
        }
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    public static class MultiLockDecree
    extends LockDecree {
        MultiLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }

        MultiLockDecree(ReleaseLockDecree releaseLockDecree) {
            super(releaseLockDecree.lockId, releaseLockDecree.requester, releaseLockDecree.managerId);
        }
    }

    public static class ReleaseLockDecree
    extends LockDecree {
        ReleaseLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }
    }

    public static class AcquireLockDecree
    extends LockDecree {
        private final long creationTime = System.currentTimeMillis();

        private AcquireLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }

        @Override
        public boolean isValid() {
            boolean result = super.isValid();
            if (!this.commited && result) {
                result = this.creationTime + 5000L > System.currentTimeMillis();
            }
            return result;
        }
    }

    public static class LockDecree
    implements Serializable {
        protected final Object lockId;
        protected final Object requester;
        protected final Object managerId;
        protected boolean commited;
        private boolean multipleLocked = false;
        private static final long serialVersionUID = 7264104838035219212L;

        private LockDecree(Object lockId, Object requester, Object managerId) {
            this.lockId = lockId;
            this.requester = requester;
            this.managerId = managerId;
        }

        public Object getKey() {
            return this.lockId;
        }

        public boolean isValid() {
            return true;
        }

        public void commit() {
            this.commited = true;
        }

        public boolean isMultipleLocked() {
            return this.multipleLocked;
        }

        public void setMultipleLocked(boolean multipleLocked) {
            this.multipleLocked = multipleLocked;
        }

        public int hashCode() {
            return this.lockId.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof LockDecree && ((LockDecree)other).lockId.equals(this.lockId);
        }
    }
}

