/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MemberInfo
implements Streamable {
    public long start = 0L;
    public long stop = 0L;
    public long num_msgs_expected = 0L;
    public long num_msgs_received = 0L;
    boolean done = false;
    long total_bytes_received = 0L;
    static NumberFormat f = NumberFormat.getNumberInstance();

    public MemberInfo() {
    }

    public MemberInfo(long num_msgs_expected) {
        this.num_msgs_expected = num_msgs_expected;
    }

    public double getMessageSec() {
        long total_time = this.stop - this.start;
        return (double)this.num_msgs_received / ((double)total_time / 1000.0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        double throughput = 0.0;
        long total_time = this.stop - this.start;
        double loss_rate = 0.0;
        long missing_msgs = this.num_msgs_expected - this.num_msgs_received;
        double msgs_sec = (double)this.num_msgs_received / ((double)total_time / 1000.0);
        throughput = (double)this.total_bytes_received / ((double)total_time / 1000.0);
        loss_rate = missing_msgs >= this.num_msgs_expected ? 100.0 : 100.0 / (double)this.num_msgs_expected * (double)missing_msgs;
        sb.append("num_msgs_expected=").append(this.num_msgs_expected).append(", num_msgs_received=");
        sb.append(this.num_msgs_received);
        sb.append(" (loss rate=").append(loss_rate).append("%)");
        sb.append(", received=").append(Util.printBytes(this.total_bytes_received));
        sb.append(", time=").append(f.format(total_time)).append("ms");
        sb.append(", msgs/sec=").append(f.format(msgs_sec));
        sb.append(", throughput=").append(Util.printBytes(throughput));
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeLong(this.start);
        out.writeLong(this.stop);
        out.writeLong(this.num_msgs_expected);
        out.writeLong(this.num_msgs_received);
        out.writeBoolean(this.done);
        out.writeLong(this.total_bytes_received);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.start = in.readLong();
        this.stop = in.readLong();
        this.num_msgs_expected = in.readLong();
        this.num_msgs_received = in.readLong();
        this.done = in.readBoolean();
        this.total_bytes_received = in.readLong();
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }
}

