/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Punctuation implements MessagePart
{
    BANG("!"),
    BANG_EQ("!="),
    BANG_EQ_EQ("!=="),
    PCT("%"),
    PCT_EQ("%="),
    AMP("&"),
    AMP_AMP("&&"),
    AMP_AMP_EQ("&&="),
    AMP_EQ("&="),
    LPAREN("("),
    RPAREN(")"),
    AST("*"),
    AST_EQ("*="),
    PLUS("+"),
    PLUS_PLUS("++"),
    PLUS_EQ("+="),
    COMMA(","),
    MINUS("-"),
    MINUS_MINUS("--"),
    MINUS_EQ("-="),
    DOT("."),
    DOT_DOT(".."),
    ELIPSIS("..."),
    COLON(":"),
    COLON_COLON("::"),
    SEMI(";"),
    LT("<"),
    LT_LT("<<"),
    LT_LT_EQ("<<="),
    LT_EQ("<="),
    EQ("="),
    EQ_EQ("=="),
    EQ_EQ_EQ("==="),
    GT(">"),
    GT_EQ(">="),
    GT_GT(">>"),
    GT_GT_EQ(">>="),
    GT_GT_GT(">>>"),
    GT_GT_GT_EQ(">>>="),
    QMARK("?"),
    LSQUARE("["),
    RSQUARE("]"),
    CARET("^"),
    CARET_EQ("^="),
    LCURLY("{"),
    PIPE("|"),
    PIPE_EQ("|="),
    PIPE_PIPE("||"),
    PIPE_PIPE_EQ("||="),
    RCURLY("}"),
    TILDE("~"),
    SLASH("/"),
    SLASH_EQ("/=");

    private String s;
    private static final Map<String, Punctuation> INSTANCE_MAP;

    private Punctuation(String s) {
        this.s = s;
    }

    @Override
    public void format(MessageContext mc, Appendable out) throws IOException {
        out.append(this.s);
    }

    public String toString() {
        return this.s;
    }

    public static Punctuation fromString(String s) {
        return INSTANCE_MAP.get(s);
    }

    static {
        INSTANCE_MAP = new HashMap<String, Punctuation>();
        for (Punctuation p : Punctuation.values()) {
            INSTANCE_MAP.put(p.toString(), p);
        }
    }
}

