/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm.ldap;

import java.util.Collection;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUtils {
    private static final Log log = LogFactory.getLog(LdapUtils.class);

    private LdapUtils() {
    }

    public static void closeContext(LdapContext ctx) {
        block3: {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Exception while closing LDAP context. ", (Throwable)e);
            }
        }
    }

    public static Collection<String> getAllAttributeValues(Attribute attr) throws NamingException {
        HashSet<String> values = new HashSet<String>();
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMore()) {
            String value = (String)e.next();
            values.add(value);
        }
        return values;
    }
}

