/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.loader.SingletonStoreCacheLoader;

public class SingletonStoreDefaultConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig {
    private static final long serialVersionUID = -5828927920142613537L;
    @Dynamic
    private boolean pushStateWhenCoordinator = true;
    @Dynamic
    private int pushStateWhenCoordinatorTimeout = 20000;

    public SingletonStoreDefaultConfig() {
        this.setSingletonStoreEnabled(true);
        this.setSingletonStoreClass(SingletonStoreCacheLoader.class.getName());
    }

    public SingletonStoreDefaultConfig(CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig base) {
        this();
        this.setSingletonStoreproperties(base.getSingletonStoreproperties());
    }

    public boolean isSingletonStoreEnabled() {
        return true;
    }

    public void setSingletonStoreEnabled(boolean singletonStoreEnabled) {
    }

    public String getSingletonStoreClass() {
        return SingletonStoreCacheLoader.class.getName();
    }

    public void setSingletonStoreClass(String singletonStoreClass) {
    }

    public void setSingletonStoreproperties(Properties props) {
        String pushStateWhenCoordinatorTimeoutStr;
        super.setSingletonStoreproperties(props);
        String pushStateWhenCoordinatorStr = props.getProperty("pushStateWhenCoordinator");
        if (pushStateWhenCoordinatorStr != null) {
            this.setPushStateWhenCoordinator(Boolean.valueOf(pushStateWhenCoordinatorStr));
        }
        if ((pushStateWhenCoordinatorTimeoutStr = props.getProperty("pushStateWhenCoordinatorTimeout")) != null) {
            this.setPushStateWhenCoordinatorTimeout(Integer.parseInt(pushStateWhenCoordinatorTimeoutStr));
        }
    }

    public boolean isPushStateWhenCoordinator() {
        return this.pushStateWhenCoordinator;
    }

    public void setPushStateWhenCoordinator(boolean pushStateWhenCoordinator) {
        this.testImmutability("pushStateWhenCoordinator");
        this.pushStateWhenCoordinator = pushStateWhenCoordinator;
    }

    public int getPushStateWhenCoordinatorTimeout() {
        return this.pushStateWhenCoordinatorTimeout;
    }

    public void setPushStateWhenCoordinatorTimeout(int pushStateWhenCoordinatorTimeout) {
        this.testImmutability("pushStateWhenCoordinatorTimeout");
        this.pushStateWhenCoordinatorTimeout = pushStateWhenCoordinatorTimeout;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SingletonStoreDefaultConfig) {
            SingletonStoreDefaultConfig other = (SingletonStoreDefaultConfig)obj;
            return other.pushStateWhenCoordinator == this.pushStateWhenCoordinator && other.pushStateWhenCoordinatorTimeout == this.pushStateWhenCoordinatorTimeout;
        }
        return false;
    }

    public int hashCode() {
        int result = 13;
        result = 23 * result + (this.pushStateWhenCoordinator ? 0 : 1);
        result = 23 * result + this.pushStateWhenCoordinatorTimeout;
        return result;
    }
}

