/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzInitializerServlet
extends HttpServlet {
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private Scheduler scheduler = null;

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        this.log("Quartz Initializer Servlet loaded, initializing Scheduler...");
        try {
            String configFile = cfg.getInitParameter("config-file");
            String shutdownPref = cfg.getInitParameter("shutdown-on-unload");
            if (shutdownPref != null) {
                this.performShutdown = Boolean.valueOf(shutdownPref);
            }
            StdSchedulerFactory factory = configFile != null ? new StdSchedulerFactory(configFile) : new StdSchedulerFactory();
            String startOnLoad = cfg.getInitParameter("start-scheduler-on-load");
            if (startOnLoad == null || Boolean.valueOf(startOnLoad).booleanValue()) {
                this.scheduler = factory.getScheduler();
                this.scheduler.start();
                this.log("Scheduler has been started...");
            } else {
                this.log("Scheduler has not been started. Use scheduler.start()");
            }
            this.log("Storing the Quartz Scheduler Factory in the servlet context at key: org.quartz.impl.StdSchedulerFactory.KEY");
            cfg.getServletContext().setAttribute(QUARTZ_FACTORY_KEY, (Object)factory);
        }
        catch (Exception e) {
            this.log("Quartz Scheduler failed to initialize: " + e.toString());
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (Exception e) {
            this.log("Quartz Scheduler failed to shutdown cleanly: " + e.toString());
            e.printStackTrace();
        }
        this.log("Quartz Scheduler successful shutdown.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(403);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(403);
    }
}

