/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsMinimalPrinterTest
extends CajaTestCase {
    private static final JsTokenType[] TYPES = JsTokenType.values();
    private static final String[] PUNCTUATORS;
    private static final Keyword[] KEYWORDS;
    private static final String WORD_CHARS = "_$ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public final void testEmptyBlock() throws Exception {
        this.assertRendered("{{}}", "{}");
    }

    public final void testAdjacentBlocks() throws Exception {
        this.assertRendered("{{}{}}", "{}{}");
    }

    public final void testSimpleStatement() throws Exception {
        this.assertRendered("{foo()}", "foo();");
    }

    public final void testSemisInsideParents() throws Exception {
        this.assertRendered("{for(var i=0,n=a.length;i<n;++i){bar(a[i])}}", "for (var i = 0, n = a.length; i < n; ++i) {  bar(a[ i ]);}");
    }

    public final void testObjectConstructor() throws Exception {
        this.assertRendered("{foo({'x':1,'y':bar({'w':4}),'z':3})}", "foo({ x: 1, y: bar({ w: 4 }), z: 3 });");
    }

    public final void testMultipleStatements() throws Exception {
        this.assertRendered("{(function(a,b,c){foo(a);bar(b);return c})(1,2,3)}", "(function (a, b, c) { foo(a); bar(b); return (c); })(1, 2, 3);");
    }

    public final void testMarkupEndStructures() throws Exception {
        this.assertRendered("{(i--)>j,k< /script>/,[[0]] >0/ / / *x}", "i-->j, k</script>/, [[0]]>0 / / / * x;");
    }

    public final void testMarkupStartStructure() throws Exception {
        this.assertRendered("{1< !--b&&c< ![CDATA[0]]}", "1<!--b && c<![CDATA[0]]");
    }

    public final void testJSON() throws Exception {
        this.assertRendered("{({'a':[1,2,3],'b':{'c':[{}],'d':[{'e':null,'f':'foo'},null]}})}", "({ a: [1,2,3], b: { c: [{}], d: [{ e: null, f: 'foo' }, null] } });");
    }

    public final void testConditional() throws Exception {
        this.assertRendered("{if(c1){foo()}else if(c2)bar();else baz()}", "if (c1) { foo(); } else if (c2) bar(); else baz();");
    }

    public final void testNumberPropertyAccess() throws Exception {
        this.assertRendered("{(3).toString()}", "(3).toString();");
    }

    public final void testComments() throws Exception {
        this.assertLexed("var x=foo;function Bar(){}var baz;a+b", "var x = foo;  /* end of line */\n/** Own line */\nfunction Bar() {}\n/* Beginning */ var baz;\na +  // Line comment\nb;");
    }

    public final void testDivisionByRegex() throws Exception {
        this.assertLexed("3/ /foo/", "3 / /foo/;");
    }

    public final void testPunctuationRun() throws Exception {
        this.assertLexed("!=|| =", "!= || =");
    }

    public final void testNegatedNegativeNumericConstants() {
        this.assertRendered("-(-3)", Operation.create(FilePosition.UNKNOWN, Operator.NEGATION, new IntegerLiteral(FilePosition.UNKNOWN, -3L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testRetokenization() throws Exception {
        long seed = Long.parseLong(System.getProperty("junit.seed", "" + System.currentTimeMillis()));
        Random rnd = new Random(seed);
        boolean pass = false;
        try {
            int i = 1000;
            while (--i >= 0) {
                List<String> randomTokens = this.generateRandomTokens(rnd);
                StringBuilder sb = new StringBuilder();
                JsMinimalPrinter pp = new JsMinimalPrinter(new Concatenator(sb));
                for (String token : randomTokens) {
                    pp.consume(token);
                }
                pp.noMoreTokens();
                ArrayList<String> actualTokens = new ArrayList<String>();
                try {
                    JsLexer lex = new JsLexer(this.fromString(sb.toString()));
                    while (lex.hasNext()) {
                        actualTokens.add(lex.next().text);
                    }
                }
                catch (ParseException ex) {
                    for (String tok : randomTokens) {
                        System.err.println(StringLiteral.toQuotedValue(tok));
                    }
                    System.err.println("<<<" + sb + ">>>");
                    throw ex;
                }
                MoreAsserts.assertListsEqual(randomTokens, actualTokens);
            }
            pass = true;
        }
        finally {
            if (!pass) {
                System.err.println("Using seed " + seed);
            }
        }
    }

    public final void testSpacingAroundBrackets1() {
        this.assertTokens("longObjectInstance.reallyLongMethodName(a,b,c,d)", "longObjectInstance", ".", "reallyLongMethodName", "(", "a", ",", "b", ",", "c", ",", "d", ")", ";");
    }

    public final void testSpacingAroundBrackets2() {
        this.assertTokens("longObjectInstance.reallyLongMethodName(a,b,c,d)", "longObjectInstance", ".", "reallyLongMethodName", "(", "a", ",", "b", ",", "c", ",", "\n", "d", ")", ";");
    }

    public final void testSpacingAroundBrackets3() {
        this.assertTokens("longObjectInstance.reallyLongMethodName(a,b,c,d)", "longObjectInstance", ".", "reallyLongMethodName", "(", "\n", "a", ",", "b", ",", "c", ",", "d", ")", ";");
    }

    public final void testSpacingAroundBrackets4() {
        this.assertTokens("var x=({'fooBar':[0,1,2,]})", "var", "x", "=", "(", "{", "'fooBar'", ":", "[", "\n", "0", ",", "1", ",", "2", ",", "]", "}", ")", ";");
    }

    public final void testConfusedTokenSequences() {
        this.assertTokens("< ! =", "<", "!", "=");
        this.assertTokens("< !=", "<", "!=");
    }

    public final void testNumbersAndDots() {
        this.assertTokens("2 .toString()", "2", ".", "toString", "(", ")");
        this.assertTokens("2..toString()", "2.", ".", "toString", "(", ")");
        this.assertTokens("2. .5", "2.", ".5");
    }

    public final void testRestrictedSemicolonInsertion() throws Exception {
        Block node = this.js(this.fromString("var x=abcd+\n+ef;return 1-\n-c;if(b)throw new\nError();break label;do\nnothing;while(0);continue top;a-\n-b;number=counter++;number=counter--;number=n-++counter"));
        StringBuilder out = new StringBuilder();
        JsMinimalPrinter pp = new JsMinimalPrinter(new Concatenator(out));
        pp.setLineLengthLimit(10);
        node.render(new RenderContext(pp));
        pp.noMoreTokens();
        JsMinimalPrinterTest.assertEquals((String)"{var x=abcd+\n+ef;return 1-\n-c;if(b)throw new\nError();break label;do\nnothing;while(0);continue top;a-\n-b;number=counter++;number=counter--;number=n-++counter}", (String)out.toString());
    }

    public final void testNoops() throws ParseException {
        Block b = this.js(this.fromString("for (;;) {", "  if (foo)", "    bar();", "  else", "    ;", "}"));
        StringBuilder out = new StringBuilder();
        JsMinimalPrinter pp = new JsMinimalPrinter(new Concatenator(out));
        b.render(new RenderContext(pp));
        pp.noMoreTokens();
        JsMinimalPrinterTest.assertEquals((String)"{for(;;){if(foo)bar();else;}}", (String)out.toString());
    }

    private List<String> generateRandomTokens(Random rnd) {
        ArrayList<String> tokens = new ArrayList<String>();
        String last = null;
        int i = 10;
        block15: while (--i >= 0) {
            String tok;
            block0 : switch (TYPES[rnd.nextInt(TYPES.length)]) {
                case COMMENT: {
                    continue block15;
                }
                case STRING: {
                    tok = StringLiteral.toQuotedValue(JsMinimalPrinterTest.randomString(rnd));
                    break;
                }
                case REGEXP: {
                    tokens.add("=");
                    StringBuilder out = new StringBuilder();
                    out.append('/');
                    Escaping.normalizeRegex((CharSequence)JsMinimalPrinterTest.randomString(rnd), false, false, out);
                    out.append('/');
                    if (rnd.nextBoolean()) {
                        out.append('g');
                    }
                    if (rnd.nextBoolean()) {
                        out.append('m');
                    }
                    if (rnd.nextBoolean()) {
                        out.append('i');
                    }
                    tok = out.toString();
                    break;
                }
                case PUNCTUATION: {
                    tok = PUNCTUATORS[rnd.nextInt(PUNCTUATORS.length)];
                    if (tok.startsWith("/")) {
                        tokens.add("3");
                    }
                    if (!"}".equals(tok) || !";".equals(last)) break;
                    tok = "{";
                    break;
                }
                case WORD: {
                    tok = JsMinimalPrinterTest.randomWord(rnd);
                    break;
                }
                case KEYWORD: {
                    tok = KEYWORDS[rnd.nextInt(KEYWORDS.length)].toString();
                    break;
                }
                case INTEGER: {
                    int j = rnd.nextInt(Integer.MAX_VALUE);
                    switch (rnd.nextInt(3)) {
                        case 0: {
                            tok = Integer.toString(j, 10);
                            break block0;
                        }
                        case 1: {
                            tok = "0" + Integer.toString(Math.abs(j), 8);
                            break block0;
                        }
                    }
                    tok = "0x" + Long.toString(Math.abs((long)j), 16);
                    break;
                }
                case FLOAT: {
                    tok = "" + Math.abs(rnd.nextFloat());
                    break;
                }
                case LINE_CONTINUATION: {
                    continue block15;
                }
                default: {
                    throw new SomethingWidgyHappenedError();
                }
            }
            tokens.add(tok);
            last = tok;
        }
        while (";".equals(last)) {
            tokens.remove(tokens.size() - 1);
            last = tokens.isEmpty() ? null : (String)tokens.get(tokens.size() - 1);
        }
        return tokens;
    }

    private static String randomWord(Random rnd) {
        int len = rnd.nextInt(100) + 1;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(WORD_CHARS.charAt(rnd.nextInt(WORD_CHARS.length())));
        }
        if (Character.isDigit(sb.charAt(0))) {
            sb.insert(0, '_');
        }
        return sb.toString();
    }

    private static String randomString(Random rnd) {
        int minCp = 0;
        int maxCp = 0;
        if (rnd.nextBoolean()) {
            minCp = 32;
            maxCp = 127;
        } else {
            minCp = 0;
            maxCp = 53248;
        }
        int len = rnd.nextInt(100) + 1;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.appendCodePoint(rnd.nextInt(maxCp - minCp) + minCp);
        }
        return sb.toString();
    }

    private void assertRendered(String golden, String input) throws Exception {
        JsLexer lex = new JsLexer(this.fromString(input));
        JsTokenQueue tq = new JsTokenQueue(lex, this.is);
        Block node = new Parser(tq, this.mq).parse();
        tq.expectEmpty();
        this.assertRendered(golden, node);
    }

    private void assertRendered(String golden, ParseTreeNode node) {
        StringBuilder out = new StringBuilder();
        JsMinimalPrinter pp = new JsMinimalPrinter(new Concatenator(out));
        node.render(new RenderContext(pp));
        pp.noMoreTokens();
        JsMinimalPrinterTest.assertEquals((String)golden, (String)out.toString());
    }

    private void assertLexed(String golden, String input) throws ParseException {
        StringBuilder out = new StringBuilder();
        JsMinimalPrinter pp = new JsMinimalPrinter(new Concatenator(out));
        JsLexer lex = new JsLexer(this.fromString(input));
        while (lex.hasNext()) {
            Token<JsTokenType> t = lex.next();
            pp.mark(t.pos);
            pp.consume(t.text);
        }
        pp.noMoreTokens();
        JsMinimalPrinterTest.assertEquals((String)golden, (String)out.toString());
    }

    private void assertTokens(String golden, String ... input) {
        StringBuilder out = new StringBuilder();
        JsMinimalPrinter pp = new JsMinimalPrinter(new Concatenator(out));
        for (String token : input) {
            pp.consume(token);
        }
        pp.noMoreTokens();
        JsMinimalPrinterTest.assertEquals((String)golden, (String)out.toString());
    }

    static {
        ArrayList<String> puncStrs = new ArrayList<String>();
        JsLexer.getPunctuationTrie().toStringList(puncStrs);
        PUNCTUATORS = puncStrs.toArray(new String[0]);
        KEYWORDS = Keyword.values();
    }
}

