/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.serialization.model.TypeModel;
import org.exoplatform.commons.serialization.model.TypeModelBuilder;
import org.exoplatform.commons.serialization.model.metadata.DomainMetaData;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeDomain {
    private static final Logger log = LoggerFactory.getLogger(TypeDomain.class);
    private final DomainMetaData metaData;
    private final Map<String, TypeModel<?>> typeModelMap;
    private final Map<String, TypeModel<?>> immutableTypeModelMap;
    private final Collection<TypeModel<?>> immutableTypeModelSet;
    private final boolean buildIfAbsent;
    private final Object lock;

    public TypeDomain(boolean putIfAbsent) {
        this(new DomainMetaData(), putIfAbsent);
    }

    public TypeDomain() {
        this(new DomainMetaData(), false);
    }

    public TypeDomain(DomainMetaData metaData) {
        this(metaData, false);
    }

    public TypeDomain(DomainMetaData metaData, boolean buildIfAbsent) {
        ConcurrentHashMap typeModelMap = new ConcurrentHashMap();
        Map immutableTypeModelMap = Collections.unmodifiableMap(typeModelMap);
        Collection immutableTypeModelSet = Collections.unmodifiableCollection(typeModelMap.values());
        this.typeModelMap = typeModelMap;
        this.immutableTypeModelMap = immutableTypeModelMap;
        this.immutableTypeModelSet = immutableTypeModelSet;
        this.buildIfAbsent = buildIfAbsent;
        this.metaData = new DomainMetaData(metaData);
        this.lock = new Object();
    }

    public Map<String, TypeModel<?>> getTypeModelMap() {
        return this.immutableTypeModelMap;
    }

    public boolean getBuildIfAbsent() {
        return this.buildIfAbsent;
    }

    public Collection<TypeModel<?>> getTypeModels() {
        return this.immutableTypeModelSet;
    }

    public TypeModel<?> getTypeModel(String typeName) {
        if (typeName == null) {
            throw new NullPointerException();
        }
        return this.typeModelMap.get(typeName);
    }

    public <O> TypeModel<O> getTypeModel(Class<O> javaType) {
        return this.get(javaType, this.buildIfAbsent);
    }

    public <O> TypeModel<O> addTypeModel(Class<O> javaType) {
        return this.get(javaType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <O> TypeModel<O> get(Class<O> javaType, boolean create) {
        if (javaType == null) {
            throw new NullPointerException();
        }
        TypeModel<Object> model = this.typeModelMap.get(javaType.getName());
        if (model == null && create) {
            Object object = this.lock;
            synchronized (object) {
                TypeModelBuilder builder = new TypeModelBuilder(this.metaData, this.immutableTypeModelMap);
                model = builder.build(javaType);
                this.typeModelMap.putAll(builder.getAddedTypeModels());
            }
        }
        return model;
    }

    public int getSize() {
        return this.typeModelMap.size();
    }
}

