/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.store.LockObtainFailedException;

class CommittableIndexReader
extends FilterIndexReader {
    private volatile long modCount;
    private final boolean transientDeletions;
    private final Set<Integer> deletedDocs;

    CommittableIndexReader(IndexReader in, boolean transientDeletions) {
        super(in);
        this.modCount = in.getVersion();
        this.transientDeletions = transientDeletions;
        this.deletedDocs = transientDeletions ? new CopyOnWriteArraySet() : null;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        super.doDelete(n);
        ++this.modCount;
    }

    public void deleteDocument(int docNum) throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.transientDeletions) {
            this.deletedDocs.add(docNum);
            ++this.modCount;
        } else {
            super.deleteDocument(docNum);
        }
    }

    public boolean isDeleted(int n) {
        if (this.transientDeletions) {
            return this.deletedDocs.contains(n);
        }
        return super.isDeleted(n);
    }

    long getModificationCount() {
        return this.modCount;
    }
}

