/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.groovyscript.text.TemplateStatistic;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@ManagedDescription(value="Template statistic service")
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="statistic"), @Property(key="type", value="template")})
@RESTEndpoint(path="templatestatistics")
public class TemplateStatisticService {
    final Map<String, TemplateStatistic> apps = new ConcurrentHashMap<String, TemplateStatistic>();
    private final String ASC = "ASC";
    private final String DESC = "DESC";

    public TemplateStatistic getTemplateStatistic(String name) {
        TemplateStatistic app = this.apps.get(name);
        if (app == null) {
            app = new TemplateStatistic(name);
            this.apps.put(name, app);
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The list of template identifiers sorted alphabetically")
    public String[] getTemplateList() {
        LinkedList<Map.Entry<String, TemplateStatistic>> list = new LinkedList<Map.Entry<String, TemplateStatistic>>(this.apps.entrySet());
        String[] app = new String[list.size()];
        int index = 0;
        for (Map.Entry entry : list) {
            app[index] = (String)entry.getKey();
            ++index;
        }
        return app;
    }

    @Managed
    @ManagedDescription(value="The maximum rendering time of a specified template in seconds")
    @Impact(value=ImpactType.READ)
    public double getMaxTime(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return this.toSeconds(app.getMaxTime());
    }

    @Managed
    @ManagedDescription(value="The minimum rendering time of a specified template in seconds")
    @Impact(value=ImpactType.READ)
    public double getMinTime(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return this.toSeconds(app.getMinTime());
    }

    @Managed
    @ManagedDescription(value="The rendering count of a specified template")
    @Impact(value=ImpactType.READ)
    public long getExecutionCount(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return app.executionCount();
    }

    @Managed
    @ManagedDescription(value="The average rendering time of a specified template in seconds")
    @Impact(value=ImpactType.READ)
    public double getAverageTime(@ManagedDescription(value="The template id") @ManagedName(value="templateId") String name) {
        TemplateStatistic app = this.apps.get(name);
        return this.toSeconds(app.getAverageTime());
    }

    @Managed
    @ManagedDescription(value="The list of the 10 slowest templates")
    public String[] getSlowestTemplates() {
        HashMap<String, Double> application = new HashMap<String, Double>();
        for (Map.Entry<String, TemplateStatistic> entry : this.apps.entrySet()) {
            String url = entry.getKey();
            application.put(url, this.getAverageTime(url));
        }
        return this.sort(application, "DESC");
    }

    @Managed
    @ManagedDescription(value="The list of the 10 most executed templates")
    public String[] getMostExecutedTemplates() {
        HashMap<String, Long> application = new HashMap<String, Long>();
        for (Map.Entry<String, TemplateStatistic> entry : this.apps.entrySet()) {
            String url = entry.getKey();
            application.put(url, this.getExecutionCount(url));
        }
        return this.sort(application, "DESC");
    }

    @Managed
    @ManagedDescription(value="The list of the 10 fastest templates")
    public String[] getFastestTemplates() {
        HashMap<String, Double> application = new HashMap<String, Double>();
        for (Map.Entry<String, TemplateStatistic> entry : this.apps.entrySet()) {
            String url = entry.getKey();
            application.put(url, this.getAverageTime(url));
        }
        return this.sort(application, "ASC");
    }

    private <T extends Comparable<T>> String[] sort(Map<String, T> source, final String order) {
        String[] app = new String[10];
        ArrayList<Map.Entry<String, T>> list = new ArrayList<Map.Entry<String, T>>(source.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, T>>(){

            @Override
            public int compare(Map.Entry<String, T> o1, Map.Entry<String, T> o2) {
                Comparable value1 = (Comparable)o1.getValue();
                Comparable value2 = (Comparable)o2.getValue();
                if ("DESC".equals(order)) {
                    Comparable tmp = value1;
                    value1 = value2;
                    value2 = tmp;
                }
                return value1.compareTo(value2);
            }
        });
        int index = 0;
        for (Map.Entry entry : list) {
            app[index] = (String)entry.getKey();
            if (++index < app.length) continue;
            break;
        }
        return app;
    }

    private double toSeconds(double value) {
        return value == -1.0 ? -1.0 : value / 1000.0;
    }
}

