/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.completion;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.crsh.cli.completers.EmptyCompleter;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.Completion;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completer;

class ParameterCompletion
extends Completion {
    private final String prefix;
    private final Delimiter delimiter;
    private final ParameterDescriptor parameter;
    private final Completer completer;

    public ParameterCompletion(String prefix, Delimiter delimiter, ParameterDescriptor parameter, Completer completer) {
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.parameter = parameter;
        this.completer = completer;
    }

    @Override
    public CompletionMatch complete() throws CompletionException {
        Class<? extends Completer> completerType = this.parameter.getCompleterType();
        Completer completer = null;
        if (completerType != EmptyCompleter.class) {
            if (completerType.isInstance(this.completer)) {
                completer = this.completer;
            } else {
                Constructor<? extends Completer> ctor;
                try {
                    ctor = completerType.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ignore) {
                    throw new CompletionException("The completer " + completerType.getName() + " does not provide a no arg constructor");
                }
                if (Modifier.isPublic(ctor.getModifiers())) {
                    try {
                        completer = ctor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        throw new CompletionException("The completer " + completerType.getName() + " cannot be abstract");
                    }
                    catch (InvocationTargetException e) {
                        throw new CompletionException(e.getCause());
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                } else {
                    throw new CompletionException("The completer " + completerType.getName() + " constructor must be public");
                }
            }
        }
        if (completer != null) {
            try {
                return new CompletionMatch(this.delimiter, completer.complete(this.parameter, this.prefix));
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }
        return new CompletionMatch(this.delimiter, org.crsh.cli.spi.Completion.create());
    }
}

