/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import java.util.Collection;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.FindById;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.core.api.workspace.GroupSiteContainer;
import org.gatein.mop.core.api.workspace.PortalSiteContainer;
import org.gatein.mop.core.api.workspace.SiteContainer;
import org.gatein.mop.core.api.workspace.UserSiteContainer;
import org.gatein.mop.core.api.workspace.WorkspaceCustomizationContextImpl;
import org.gatein.mop.core.api.workspace.WorkspaceObjectImpl;

@PrimaryType(name="mop:workspace")
public abstract class WorkspaceImpl
extends WorkspaceObjectImpl
implements Workspace {
    public ObjectType<? extends Workspace> getObjectType() {
        return ObjectType.WORKSPACE;
    }

    @OneToOne
    @MappedBy(value="mop:portalsites")
    @Owner
    public abstract PortalSiteContainer getPortalSites();

    @OneToOne
    @MappedBy(value="mop:groupsites")
    @Owner
    public abstract GroupSiteContainer getGroupSites();

    @OneToOne
    @MappedBy(value="mop:usersites")
    @Owner
    public abstract UserSiteContainer getUserSites();

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract WorkspaceCustomizationContextImpl getCustomizationContext();

    @FindById
    public abstract CustomizationContext resolveContext(String var1);

    private <S extends Site> SiteContainer getSiteContainer(ObjectType<S> siteType) {
        if (siteType == ObjectType.PORTAL_SITE) {
            return this.getPortalSites();
        }
        if (siteType == ObjectType.GROUP_SITE) {
            return this.getGroupSites();
        }
        if (siteType == ObjectType.USER_SITE) {
            return this.getUserSites();
        }
        throw new UnsupportedOperationException();
    }

    public <S extends Site> S getSite(ObjectType<S> siteType, String siteName) {
        SiteContainer sites = this.getSiteContainer(siteType);
        return (S)sites.getSite(siteName);
    }

    public Collection<Site> getSites() {
        throw new UnsupportedOperationException();
    }

    public <S extends Site> Collection<S> getSites(ObjectType<S> siteType) {
        SiteContainer sites = this.getSiteContainer(siteType);
        return sites.getAllSites();
    }

    public <S extends Site> S addSite(ObjectType<S> siteType, String name) {
        SiteContainer sites = this.getSiteContainer(siteType);
        return (S)sites.addSite(name);
    }
}

