/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.util.Nameable;
import org.jsecurity.web.servlet.ServletContextSupport;

public abstract class OncePerRequestFilter
extends ServletContextSupport
implements Filter,
Nameable {
    private static final Log log = LogFactory.getLog(OncePerRequestFilter.class);
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";
    protected FilterConfig filterConfig;
    private String name;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.setServletContext(filterConfig.getServletContext());
    }

    protected String getName() {
        FilterConfig config;
        if (this.name == null && (config = this.getFilterConfig()) != null) {
            this.name = config.getFilterName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.setFilterConfig(filterConfig);
        try {
            this.onFilterConfigSet();
        }
        catch (Exception e) {
            if (e instanceof ServletException) {
                throw (ServletException)((Object)e);
            }
            if (log.isErrorEnabled()) {
                log.error((Object)("Unable to start Filter: [" + e.getMessage() + "]."), (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
    }

    protected void onFilterConfigSet() throws Exception {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        if (request.getAttribute(alreadyFilteredAttributeName) != null || this.shouldNotFilter(request)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Filter already executed.  Proceeding without invoking this filter.");
            }
            filterChain.doFilter(request, response);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Filter not yet executed.  Executing now.");
            }
            request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
            this.doFilterInternal(request, response, filterChain);
        }
    }

    protected String getAlreadyFilteredAttributeName() {
        String name = this.getName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ALREADY_FILTERED_SUFFIX;
    }

    protected boolean shouldNotFilter(ServletRequest request) throws ServletException {
        return false;
    }

    protected abstract void doFilterInternal(ServletRequest var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException;

    public void destroy() {
    }
}

