/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.Annotation;
import com.google.caja.ancillary.jsdoc.AnnotationHandlers;
import com.google.caja.ancillary.jsdoc.BlockAnnotation;
import com.google.caja.ancillary.jsdoc.Comment;
import com.google.caja.ancillary.jsdoc.CommentParser;
import com.google.caja.ancillary.jsdoc.JsdocMessageType;
import com.google.caja.ancillary.jsdoc.Summarizer;
import com.google.caja.ancillary.jsdoc.TextAnnotation;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SwitchCase;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.js.WhileLoop;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Criterion;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsdocRewriter {
    private final MessageQueue mq;
    private final MessageContext mc;
    private final Set<Token<?>> consumed = Sets.newHashSet();
    private final AnnotationHandlers handlers;
    private static final Pattern TAG = Pattern.compile("(</?)([a-z]+[1-6]?)([^<>]*>)|(&(?:amp|lt|gt|quot|#(?:x[0-9a-f]+|[0-9]+));)|<!--.*?-->|[<>&]", 34);

    JsdocRewriter(AnnotationHandlers handlers, MessageContext mc, MessageQueue mq) {
        this.mc = mc;
        this.mq = mq;
        this.handlers = handlers;
    }

    ParseTreeNode rewriteFile(ParseTreeNode js) {
        Expression fileOverview = this.extractFileOverview(js);
        ParseTreeNode fileBody = this.rewrite(js);
        if (fileOverview != null) {
            return QuasiBuilder.substV("{ jsdoc___.documentFile(@fileName, @fileOverview); @fileBody; }", "fileName", StringLiteral.valueOf(js.getFilePosition(), JsdocRewriter.format(js.getFilePosition().source(), this.mc)), "fileOverview", fileOverview, "fileBody", fileBody);
        }
        return fileBody;
    }

    ParseTreeNode rewritePackageDocs(InputSource is, Comment cmt) {
        Expression packageDocs = this.commentToJson(this.normalizeHtml(cmt));
        if (packageDocs == null) {
            return null;
        }
        return QuasiBuilder.substV("{ jsdoc___.documentFile(@packageName, @packageDocs); }", "packageName", StringLiteral.valueOf(cmt.getFilePosition(), JsdocRewriter.format(is, this.mc)), "packageDocs", packageDocs);
    }

    private Expression extractFileOverview(ParseTreeNode js) {
        Comment fileOverview = this.getDocComment(js, new Criterion<Comment>(){

            @Override
            public boolean accept(Comment c) {
                for (Annotation a : c.children()) {
                    String name;
                    if (!(a instanceof BlockAnnotation) || !"fileoverview".equals(name = ((BlockAnnotation)a).getValue())) continue;
                    return true;
                }
                return false;
            }
        });
        if (fileOverview == null && js instanceof Block && !js.children().isEmpty()) {
            return this.extractFileOverview(js.children().get(0));
        }
        if (fileOverview != null) {
            List<? extends Annotation> flattened = Lists.newArrayList();
            for (Annotation a : fileOverview.children()) {
                if (a instanceof BlockAnnotation && "fileoverview".equals(a.getValue())) {
                    flattened.addAll(a.children());
                    continue;
                }
                flattened.add(a);
            }
            Comment overview = new Comment(this.normalizeHtml(flattened), fileOverview.getFilePosition());
            return this.commentToJson(overview);
        }
        return null;
    }

    private ParseTreeNode rewrite(ParseTreeNode js) {
        ParseTreeNode result = js instanceof FunctionConstructor || js instanceof FunctionDeclaration ? this.documentFunction(js) : (js instanceof Declaration ? this.documentDeclaration((Declaration)js) : (js instanceof ObjectConstructor ? this.documentObjectConstructor((ObjectConstructor)js) : (js instanceof Expression ? this.documentExpression((Expression)js) : (js instanceof ExpressionStmt ? this.documentExpressionStmt((ExpressionStmt)js) : (js instanceof ReturnStmt ? this.documentReturnStmt((ReturnStmt)js) : (js instanceof Loop ? this.documentLoop((Loop)js) : (js instanceof Conditional ? this.documentConditional((Conditional)js) : (JsdocRewriter.isScopeBlock(js) ? this.delayDocingOfUninitializedVariables((Statement)js) : ParseTreeNodes.newNodeInstance(js.getClass(), js.getFilePosition(), js.getValue(), this.rewriteAll(js.children()))))))))));
        return result;
    }

    private static boolean isScopeBlock(ParseTreeNode js) {
        return js instanceof Block || js instanceof SwitchCase;
    }

    private Expression documentExpression(Expression js) {
        return this.documentExpression(js, this.getDocCommentJson(js));
    }

    private Expression documentExpression(Expression js, Expression doc) {
        FilePosition pos = js.getFilePosition();
        if (js instanceof Operation) {
            Operation operation = (Operation)js;
            Operator op = operation.getOperator();
            if (doc != null && Operator.ASSIGN == op) {
                return (Expression)QuasiBuilder.substV("@lhs = jsdoc___.document(@rhs, @doc)", "lhs", this.rewrite(js.children().get(0)), "rhs", this.rewrite(js.children().get(1)), "doc", doc);
            }
            switch (op) {
                case TYPEOF: {
                    return (Expression)QuasiBuilder.substV("typeof @e === 'undefined'? 'undefined': typeof jsdoc___.unwrap(@e)", "e", this.rewrite(operation.children().get(0)));
                }
                case NOT: 
                case EQUAL: 
                case NOT_EQUAL: 
                case STRICTLY_EQUAL: 
                case STRICTLY_NOT_EQUAL: {
                    List<Expression> unwrappedChildren = Lists.newArrayList();
                    for (Expression expression : operation.children()) {
                        unwrappedChildren.add((Expression)QuasiBuilder.substV("jsdoc___.unwrap(@e)", "e", this.rewrite(expression)));
                    }
                    return Operation.create(pos, op, unwrappedChildren.toArray(new Expression[0]));
                }
                case LOGICAL_OR: {
                    return (Expression)QuasiBuilder.substV("jsdoc___.unwrap(@a) ? @a : @b", "a", this.rewrite(operation.children().get(0)), "b", this.rewrite(operation.children().get(1)));
                }
                case LOGICAL_AND: {
                    return (Expression)QuasiBuilder.substV("!jsdoc___.unwrap(@a) ? @a : @b", "a", this.rewrite(operation.children().get(0)), "b", this.rewrite(operation.children().get(1)));
                }
                case TERNARY: {
                    return (Expression)QuasiBuilder.substV("jsdoc___.unwrap(@a) ? @b : @c", "a", this.rewrite(operation.children().get(0)), "b", this.rewrite(operation.children().get(1)), "c", this.rewrite(operation.children().get(2)));
                }
            }
        }
        Expression rewritten = (Expression)ParseTreeNodes.newNodeInstance(js.getClass(), pos, js.getValue(), this.rewriteAll(js.children()));
        if (doc != null) {
            return (Expression)QuasiBuilder.substV("jsdoc___.document(@e, @doc)", "e", rewritten, "doc", doc);
        }
        if (rewritten instanceof Reference && ((Reference)rewritten).getIdentifierName().equals("__iterator__")) {
            return new Reference(new Identifier(pos, "_iterator_"));
        }
        return rewritten;
    }

    private ExpressionStmt documentExpressionStmt(ExpressionStmt js) {
        Expression doc = this.getDocCommentJson(js);
        return new ExpressionStmt(js.getFilePosition(), this.documentExpression(js.getExpression(), doc));
    }

    private ParseTreeNode documentDeclaration(Declaration js) {
        Expression doc;
        FilePosition pos = js.getFilePosition();
        if (js.getInitializer() != null && (doc = this.getDocCommentJson(js)) != null) {
            if (js instanceof FunctionDeclaration) {
                return new ParseTreeNodeContainer(Arrays.asList(ParseTreeNodes.newNodeInstance(js.getClass(), pos, js.getValue(), this.rewriteAll(js.children())), new ExpressionStmt(pos, (Expression)QuasiBuilder.substV("jsdoc___.document(@name, @doc);", "name", new Reference(js.getIdentifier()), "doc", doc))));
            }
            return QuasiBuilder.substV("var @name = jsdoc___.document(@initial, @doc);", "name", js.getIdentifier(), "initial", this.rewrite(js.getInitializer()), "doc", doc);
        }
        return ParseTreeNodes.newNodeInstance(js.getClass(), pos, js.getValue(), this.rewriteAll(js.children()));
    }

    private ParseTreeNode documentFunction(ParseTreeNode fn) {
        FunctionConstructor ctor;
        FunctionDeclaration decl;
        FilePosition pos = fn.getFilePosition();
        if (fn instanceof FunctionDeclaration) {
            decl = (FunctionDeclaration)fn;
            ctor = decl.getInitializer();
        } else {
            decl = null;
            ctor = (FunctionConstructor)fn;
        }
        Expression doc = this.getDocCommentJson(fn);
        if (doc == null) {
            doc = new ObjectConstructor(pos);
        }
        final Map fieldDocsByName = Maps.newLinkedHashMap();
        ctor.getBody().acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                if (ac.node instanceof FunctionConstructor) {
                    return false;
                }
                if (!(ac.node instanceof Operation)) {
                    return true;
                }
                Map<String, ParseTreeNode> bindings = Maps.newHashMap();
                if (QuasiBuilder.match("this.@field", ac.node, bindings) || QuasiBuilder.match("this.@field = @rhs", ac.node, bindings)) {
                    String name = ((Reference)bindings.get("field")).getIdentifierName();
                    Expression doc = JsdocRewriter.this.getDocCommentJson(ac.node);
                    if (doc == null && ac.parent.node instanceof ExpressionStmt) {
                        doc = JsdocRewriter.this.getDocCommentJson(ac.parent.node);
                    }
                    if (!fieldDocsByName.containsKey(name)) {
                        fieldDocsByName.put(name, doc);
                    } else if (doc != null) {
                        Expression oldDocs = (Expression)fieldDocsByName.get(name);
                        if (oldDocs != null) {
                            JsdocRewriter.this.mq.addMessage((MessageTypeInt)JsdocMessageType.DUPLICATE_DOCUMENTATION, ac.node.getFilePosition(), oldDocs.getFilePosition());
                        } else {
                            fieldDocsByName.put(name, doc);
                        }
                    }
                }
                return true;
            }
        }, null);
        List<ValueProperty> fieldMembers = Lists.newArrayList();
        for (Map.Entry e : fieldDocsByName.entrySet()) {
            Expression memberDoc = (Expression)e.getValue();
            if (memberDoc == null) {
                memberDoc = new ObjectConstructor(pos);
            }
            fieldMembers.add(new ValueProperty(StringLiteral.valueOf(pos, (CharSequence)e.getKey()), memberDoc));
        }
        ObjectConstructor fields = new ObjectConstructor(pos, fieldMembers);
        ParseTreeNodeContainer formals = new ParseTreeNodeContainer(ctor.getParams());
        ParseTreeNodeContainer expandedBody = new ParseTreeNodeContainer(this.rewriteAll(ctor.getBody().children()));
        FunctionConstructor newCtor = (FunctionConstructor)QuasiBuilder.substV("function @name?(@formals*) { @body* }", "name", ctor.getIdentifier(), "formals", formals, "body", expandedBody);
        if (decl == null) {
            Expression newDocCall = (Expression)QuasiBuilder.substV("jsdoc___.documentFunction(@ctor, @doc, @fields)", "ctor", newCtor, "doc", doc, "fields", fields);
            return newDocCall;
        }
        FunctionDeclaration newDecl = new FunctionDeclaration(newCtor);
        ExpressionStmt docCall = new ExpressionStmt(pos, (Expression)QuasiBuilder.substV("jsdoc___.documentFunction(@name, @doc, @fields);", "name", new Reference(ctor.getIdentifier()), "doc", doc, "fields", fields));
        return new ParseTreeNodeContainer(Arrays.asList(newDecl, docCall));
    }

    private ParseTreeNode documentObjectConstructor(ObjectConstructor o) {
        List<? extends ObjProperty> children = o.children();
        List<ObjProperty> entries = Lists.newArrayList();
        for (ObjProperty objProperty : children) {
            if (!(objProperty instanceof ValueProperty)) {
                entries.add(objProperty);
                continue;
            }
            ValueProperty vprop = (ValueProperty)objProperty;
            StringLiteral key = vprop.getPropertyNameNode();
            Expression value = vprop.getValueExpr();
            Expression docComment = this.getDocCommentJson(key);
            if (docComment == null) {
                docComment = this.getDocCommentJson(value);
            }
            entries.add(new ValueProperty(key, this.documentExpression(value, docComment)));
        }
        return new ObjectConstructor(o.getFilePosition(), entries);
    }

    private ParseTreeNode documentReturnStmt(ReturnStmt js) {
        Expression doc = this.getDocCommentJson(js);
        if (js.getReturnValue() == null) {
            return js;
        }
        return new ReturnStmt(js.getFilePosition(), this.documentExpression(js.getReturnValue(), doc));
    }

    private Loop documentLoop(Loop js) {
        List<ParseTreeNode> rewritten = this.rewriteAll(js.children());
        int condIndex = js instanceof WhileLoop ? 0 : 1;
        rewritten.set(condIndex, QuasiBuilder.substV("jsdoc___.unwrap(@cond)", "cond", rewritten.get(condIndex)));
        return (Loop)ParseTreeNodes.newNodeInstance(js.getClass(), js.getFilePosition(), js.getLabel(), rewritten);
    }

    private Conditional documentConditional(Conditional js) {
        List<ParseTreeNode> rewritten = this.rewriteAll(js.children());
        int i = 0;
        while (i + 1 < rewritten.size()) {
            rewritten.set(i, QuasiBuilder.substV("jsdoc___.unwrap(@cond)", "cond", rewritten.get(i)));
            i += 2;
        }
        return (Conditional)ParseTreeNodes.newNodeInstance(js.getClass(), js.getFilePosition(), js.getValue(), rewritten);
    }

    private Statement delayDocingOfUninitializedVariables(final Statement s) {
        final List<Declaration> uninitialized = Lists.newArrayList();
        s.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                Declaration decl;
                if (ac.node == s) {
                    return true;
                }
                if (ac.node instanceof FunctionConstructor || JsdocRewriter.isScopeBlock(ac.node)) {
                    return false;
                }
                if (ac.node instanceof Declaration && (decl = (Declaration)ac.cast(Declaration.class).node).getInitializer() == null) {
                    uninitialized.add(decl);
                }
                return true;
            }
        }, null);
        List<ExpressionStmt> docStmts = Lists.newArrayList();
        for (Declaration decl : uninitialized) {
            Expression doc = this.getDocCommentJson(decl);
            if (doc == null) continue;
            docStmts.add(new ExpressionStmt(s.getFilePosition(), (Expression)QuasiBuilder.substV("@name = jsdoc___.document(@name, @doc);", "name", new Reference(decl.getIdentifier()), "doc", doc)));
        }
        Statement rewrittenStmt = (Statement)ParseTreeNodes.newNodeInstance(s.getClass(), s.getFilePosition(), s.getValue(), this.rewriteAll(s.children()));
        if (docStmts.isEmpty()) {
            return rewrittenStmt;
        }
        return (Statement)QuasiBuilder.substV("try { @stmt; } finally { @docStmts*; }", "stmt", rewrittenStmt, "docStmts", new ParseTreeNodeContainer(docStmts));
    }

    private List<ParseTreeNode> rewriteAll(List<? extends ParseTreeNode> nodes) {
        List<ParseTreeNode> rewritten = Lists.newArrayList();
        for (ParseTreeNode parseTreeNode : nodes) {
            ParseTreeNode rnode = this.rewrite(parseTreeNode);
            if (rnode instanceof ParseTreeNodeContainer) {
                rewritten.addAll(rnode.children());
                continue;
            }
            rewritten.add(rnode);
        }
        return rewritten;
    }

    private Comment getDocComment(ParseTreeNode js, Criterion<Comment> filter) {
        for (Token<?> t : js.getComments()) {
            Comment cmt;
            if (!t.text.startsWith("/**")) continue;
            try {
                cmt = CommentParser.parseStructuredComment(CharProducer.Factory.create(new StringReader(t.text), t.pos));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(this.mq);
                continue;
            }
            if (this.consumed.contains(t) || !filter.accept(cmt)) continue;
            this.consumed.add(t);
            return cmt;
        }
        return null;
    }

    private Expression getDocCommentJson(ParseTreeNode js) {
        Comment cmt = this.getDocComment(js, Criterion.Factory.<Comment>optimist());
        if (cmt == null) {
            return null;
        }
        return this.commentToJson(cmt);
    }

    private Expression commentToJson(Comment cmt) {
        FilePosition pos = cmt.getFilePosition();
        List<Annotation> description = Lists.newArrayList();
        Map blocks = Maps.newLinkedHashMap();
        for (Annotation a : cmt.children()) {
            if (a instanceof BlockAnnotation) {
                Expression e = this.handlers.handlerFor(a).handle(a, this.mq);
                if (e == null) continue;
                String name = a.getValue();
                if (!blocks.containsKey(name)) {
                    blocks.put(name, Lists.newArrayList());
                }
                ((List)blocks.get(name)).add(e);
                continue;
            }
            description.add(a);
        }
        List<ValueProperty> docEntries = Lists.newArrayList();
        if (!description.isEmpty()) {
            BlockAnnotation desc = new BlockAnnotation("::description", description, cmt.getFilePosition());
            BlockAnnotation summary = Summarizer.summarize(desc);
            Expression descExpr = this.handlers.handlerFor(desc).handle(this.normalizeHtml(desc), this.mq);
            Expression summaryExpr = this.handlers.handlerFor(summary).handle(this.normalizeHtml(summary), this.mq);
            if (descExpr != null) {
                docEntries.add(new ValueProperty(StringLiteral.valueOf(pos, "@description"), descExpr));
            }
            if (summaryExpr != null) {
                docEntries.add(new ValueProperty(StringLiteral.valueOf(pos, "@summary"), summaryExpr));
            }
        }
        docEntries.add(new ValueProperty(StringLiteral.valueOf(pos, "@pos"), StringLiteral.valueOf(pos, JsdocRewriter.format(pos, this.mc))));
        for (Map.Entry block : blocks.entrySet()) {
            docEntries.add(new ValueProperty(StringLiteral.valueOf(pos, "@" + (String)block.getKey()), new ArrayConstructor(pos, (List)block.getValue())));
        }
        return new ObjectConstructor(pos, docEntries);
    }

    static String format(FilePosition p, MessageContext mc) {
        StringBuilder sb = new StringBuilder(JsdocRewriter.format(p.source(), mc));
        sb.append(':').append(p.startLineNo()).append('+').append(p.startCharInLine()).append(" - ");
        if (p.startLineNo() != p.endLineNo()) {
            sb.append(p.endLineNo()).append('+');
        }
        return sb.append(p.endCharInLine()).toString();
    }

    static String format(InputSource s, MessageContext mc) {
        String uriStr = s.getUri().toString();
        int tail = uriStr.lastIndexOf(47);
        for (InputSource t : mc.getInputSources()) {
            if (tail < 0) break;
            String uriStr2 = t.getUri().toString();
            int common = Math.min(tail, Math.min(uriStr.length(), uriStr2.length()));
            for (int i = 0; i < common; ++i) {
                if (uriStr.charAt(i) == uriStr2.charAt(i)) continue;
                common = i;
                break;
            }
            if (common >= tail) continue;
            tail = uriStr.lastIndexOf(47, common);
        }
        return uriStr.substring(tail + 1);
    }

    private List<Annotation> normalizeHtml(List<? extends Annotation> annotations) {
        HtmlSchema schema = HtmlSchema.getDefault(this.mq);
        List<ElKey> open = Lists.newArrayList();
        List<Annotation> normalized = Lists.newArrayList();
        int n = annotations.size();
        for (int i = 0; i < n; ++i) {
            Annotation a = annotations.get(i);
            if (a instanceof TextAnnotation) {
                Matcher m = TAG.matcher(a.getValue());
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(sb, "");
                    if (m.group(1) != null) {
                        boolean end = "</".equals(m.group(1));
                        ElKey elKey = ElKey.forHtmlElement(m.group(2));
                        HTML.Element el = schema.lookupElement(elKey);
                        if (schema.isElementAllowed(elKey)) {
                            if (end) {
                                int lindex = open.lastIndexOf(elKey);
                                if (lindex < 0) continue;
                                int j = open.size();
                                while (--j >= lindex) {
                                    sb.append("</").append(open.get(j)).append('>');
                                }
                                open.subList(lindex, open.size()).clear();
                                continue;
                            }
                            sb.append(m.group(0));
                            if (el.isEmpty()) continue;
                            open.add(elKey);
                            continue;
                        }
                        sb.append("&lt;").append(m.group(0).substring(1));
                        continue;
                    }
                    if (m.group(4) != null) {
                        sb.append(m.group(0));
                        continue;
                    }
                    String s = m.group(0);
                    if (s.startsWith("<!--")) {
                        sb.append("<!---->");
                        continue;
                    }
                    if ("&".equals(s)) {
                        sb.append("&amp;");
                        continue;
                    }
                    if (">".equals(s)) {
                        sb.append("&gt;");
                        continue;
                    }
                    sb.append("&lt;");
                }
                m.appendTail(sb);
                int j = open.size();
                while (--j >= 0) {
                    sb.append("</").append(open.get(j)).append('>');
                }
                normalized.add(new TextAnnotation(sb.toString(), a.getFilePosition()));
                continue;
            }
            normalized.add(a);
        }
        return normalized;
    }

    private Comment normalizeHtml(Comment c) {
        return new Comment(this.normalizeHtml(c.children()), c.getFilePosition());
    }

    private BlockAnnotation normalizeHtml(BlockAnnotation a) {
        return new BlockAnnotation(a.getValue(), this.normalizeHtml(a.children()), a.getFilePosition());
    }
}

