/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.itemfilters;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactQPathEntryFilter
implements QPathEntryFilter {
    private QPathEntry entry;

    public ExactQPathEntryFilter() {
    }

    public ExactQPathEntryFilter(QPathEntry entry) {
        this.entry = entry;
    }

    @Override
    public boolean isExactName() {
        return true;
    }

    @Override
    public QPathEntry getQPathEntry() {
        return this.entry;
    }

    @Override
    public boolean accept(ItemData item) {
        QPathEntry itemEntry = item.getQPath().getEntries()[item.getQPath().getDepth()];
        return this.entry.equals(itemEntry);
    }

    @Override
    public List<? extends ItemData> accept(List<? extends ItemData> itemData) {
        ArrayList<ItemData> result = new ArrayList<ItemData>();
        for (int i = 0; i < itemData.size(); ++i) {
            if (!this.accept(itemData.get(i))) continue;
            result.add(itemData.get(i));
            break;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof QPathEntryFilter) {
            QPathEntryFilter that = (QPathEntryFilter)o;
            return this.getQPathEntry().equals(that.getQPathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf = this.entry.getNamespace().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        buf = this.entry.getName().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        out.writeInt(this.entry.getIndex());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        String namespace = new String(buf, "UTF-8");
        buf = new byte[in.readInt()];
        in.readFully(buf);
        String localName = new String(buf, "UTF-8");
        int index = in.readInt();
        this.entry = new QPathEntry(namespace, localName, index);
    }
}

