/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.tokenizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.tokenizer.Token;

public abstract class Tokenizer
implements Iterator<Token> {
    private ArrayList<Token> stack = new ArrayList();
    private int ptr = 0;
    private int index = 0;

    protected Tokenizer() {
    }

    @Override
    public final boolean hasNext() {
        if (this.ptr < this.stack.size()) {
            return true;
        }
        Token next = this.parse();
        if (next != null) {
            this.stack.add(next);
        }
        return next != null;
    }

    public final void pushBack(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ptr - count < 0) {
            throw new IllegalStateException("Trying to push back too many tokens");
        }
        while (count > 0) {
            this.index -= this.stack.get((int)(--this.ptr)).raw.length();
            --count;
        }
    }

    public final Token peek() {
        if (this.hasNext()) {
            return this.stack.get(this.ptr);
        }
        return null;
    }

    @Override
    public final Token next() {
        if (this.hasNext()) {
            Token token = this.stack.get(this.ptr++);
            this.index += token.raw.length();
            return token;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final void pushBack() {
        this.pushBack(1);
    }

    protected abstract Token parse();

    public final int getIndex() {
        return this.index;
    }

    public abstract Delimiter getDelimiter();
}

