/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.Arrays;

public abstract class Layout {
    private static final Layout RTL = new Layout(){

        @Override
        int[] compute(boolean spaced, int length, int[] actualLengths, int[] minLengths) {
            int[] ret = (int[])actualLengths.clone();
            int totalLength = 0;
            for (int i = 0; i < actualLengths.length; ++i) {
                totalLength += actualLengths[i];
                if (!spaced || i <= 0) continue;
                ++totalLength;
            }
            int index = minLengths.length - 1;
            while (totalLength > length && index >= 0) {
                int delta = totalLength - length;
                int bar = actualLengths[index] - minLengths[index];
                if (delta <= bar) {
                    totalLength = length;
                    int n = index;
                    ret[n] = ret[n] - delta;
                    continue;
                }
                int foo = actualLengths[index];
                if (spaced && index > 0) {
                    ++foo;
                }
                totalLength -= foo;
                ret[index] = 0;
                --index;
            }
            if (totalLength > 0) {
                if (index == minLengths.length - 1) {
                    return ret;
                }
                return Arrays.copyOf(ret, index + 1);
            }
            return null;
        }
    };

    public static Layout flow() {
        return RTL;
    }

    public static Layout weighted(int ... weights) throws NullPointerException, IllegalArgumentException {
        return new Weighted(weights);
    }

    abstract int[] compute(boolean var1, int var2, int[] var3, int[] var4);

    public static class Weighted
    extends Layout {
        private final int[] weights;

        private Weighted(int ... weights) throws NullPointerException, IllegalArgumentException {
            if (weights == null) {
                throw new NullPointerException("No null weights accepted");
            }
            for (int weight : weights) {
                if (weight >= 0) continue;
                throw new IllegalArgumentException("No negative weight accepted");
            }
            this.weights = (int[])weights.clone();
        }

        public int[] getWeights() {
            return (int[])this.weights.clone();
        }

        @Override
        int[] compute(boolean spaced, int length, int[] actualLengths, int[] minLengths) {
            int count;
            for (int i = count = Math.min(actualLengths.length, this.weights.length); i > 0; --i) {
                int totalLength = length;
                int totalWeight = 0;
                for (int j = 0; j < i; ++j) {
                    totalWeight += this.weights[j];
                    if (!spaced || j <= 0) continue;
                    --totalLength;
                }
                int[] ret = new int[i];
                for (int j = 0; j < i; ++j) {
                    int w = totalLength * this.weights[j];
                    if (w < minLengths[j] * totalWeight) {
                        ret = null;
                        break;
                    }
                    ret[j] = w;
                }
                if (ret == null) continue;
                int err = 0;
                for (int j = 0; j < ret.length; ++j) {
                    int value = ret[j] / totalWeight;
                    int lower = value * totalWeight;
                    int errLower = err + ret[j] - lower;
                    int upper = lower + totalWeight;
                    int errUpper = err + ret[j] - upper;
                    if (Math.abs(errLower) < Math.abs(errUpper)) {
                        ret[j] = value;
                        err = errLower;
                        continue;
                    }
                    ret[j] = value + 1;
                    err = errUpper;
                }
                return ret;
            }
            return null;
        }
    }
}

