/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.AutoCreated;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.Mandatory;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPolicy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Properties;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.bean.BeanFilter;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanInfoBuilder;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.AttributeMapping;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.Constants;
import org.chromattic.metamodel.mapping.CreateMapping;
import org.chromattic.metamodel.mapping.DestroyMapping;
import org.chromattic.metamodel.mapping.FindByIdMapping;
import org.chromattic.metamodel.mapping.InvalidMappingException;
import org.chromattic.metamodel.mapping.MethodMapping;
import org.chromattic.metamodel.mapping.NodeAttributeType;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertiesMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.RelationshipMapping;
import org.chromattic.metamodel.mapping.ValueMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyDefinitionMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyMetaType;
import org.chromattic.metamodel.type.SimpleTypeMapping;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.annotation.AnnotationInfo;
import org.reflext.api.annotation.AnnotationParameterInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.api.introspection.AnnotationTarget;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMappingBuilder {
    private final TypeResolver<Type> domain = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());
    private final ClassTypeInfo FORMATTED_BY = (ClassTypeInfo)this.domain.resolve(FormattedBy.class);
    private final AnnotationType<AnnotationInfo, ?> FORMATTED_BY_ANNOTATION_TYPE = AnnotationType.get((ClassTypeInfo)this.FORMATTED_BY);
    private final SimpleTypeResolver simpleTypeResolver;

    public BeanMappingBuilder() {
        this(new SimpleTypeResolver());
    }

    public BeanMappingBuilder(SimpleTypeResolver simpleTypeResolver) {
        this.simpleTypeResolver = simpleTypeResolver;
    }

    public Map<ClassTypeInfo, BeanMapping> build(ClassTypeInfo ... classTypes) {
        return this.build(Collections.set((Object[])classTypes));
    }

    public Map<ClassTypeInfo, BeanMapping> build(Set<ClassTypeInfo> classTypes) {
        classTypes = new HashSet<ClassTypeInfo>(classTypes);
        final AtomicReference objectCTI = new AtomicReference();
        BeanFilter filter = new BeanFilter(){

            public boolean accept(ClassTypeInfo cti) {
                boolean accept = false;
                if (cti.getName().equals(Object.class.getName())) {
                    objectCTI.set(cti);
                    accept = true;
                } else {
                    accept |= cti.getDeclaredAnnotation(AnnotationType.get(PrimaryType.class)) != null;
                    accept |= cti.getDeclaredAnnotation(AnnotationType.get(MixinType.class)) != null;
                }
                return accept;
            }
        };
        Map<ClassTypeInfo, BeanInfo> beans = new BeanInfoBuilder(this.simpleTypeResolver, filter).build(classTypes);
        Context ctx = new Context(new SimpleTypeResolver(), new HashSet<BeanInfo>(beans.values()));
        if (objectCTI.get() != null) {
            BeanInfo objectBean = beans.remove(objectCTI.get());
            BeanMapping objectMapping = new BeanMapping(objectBean, NodeTypeKind.PRIMARY, "nt:base", NameConflictResolution.FAIL, null, false, true, null);
            ctx.beanMappings.put(objectBean, objectMapping);
            ctx.beans.remove(objectBean);
        }
        Map<BeanInfo, BeanMapping> beanMappings = ctx.build();
        for (BeanMapping beanMapping : beanMappings.values()) {
            for (PropertyMapping<?, ?, ?> propertyMapping : beanMapping.getProperties().values()) {
                if (!(propertyMapping instanceof RelationshipMapping)) continue;
                RelationshipMapping relationshipMapping = (RelationshipMapping)propertyMapping;
                relationshipMapping.resolve();
            }
        }
        HashMap<ClassTypeInfo, BeanMapping> classTypeMappings = new HashMap<ClassTypeInfo, BeanMapping>();
        for (Map.Entry<BeanInfo, BeanMapping> beanMapping : beanMappings.entrySet()) {
            classTypeMappings.put(beanMapping.getKey().getClassType(), beanMapping.getValue());
        }
        return classTypeMappings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context {
        final SimpleTypeResolver typeResolver;
        final Map<ClassTypeInfo, BeanInfo> beanClassTypeMap;
        final Set<BeanInfo> beans;
        final Map<BeanInfo, BeanMapping> beanMappings;

        private Context(SimpleTypeResolver typeResolver, Set<BeanInfo> beans) {
            HashMap<ClassTypeInfo, BeanInfo> beanClassTypeMap = new HashMap<ClassTypeInfo, BeanInfo>();
            for (BeanInfo bean : beans) {
                beanClassTypeMap.put(bean.getClassType(), bean);
            }
            this.typeResolver = typeResolver;
            this.beanClassTypeMap = beanClassTypeMap;
            this.beans = beans;
            this.beanMappings = new HashMap<BeanInfo, BeanMapping>();
        }

        public Map<BeanInfo, BeanMapping> build() {
            Iterator<BeanInfo> iterator;
            while ((iterator = this.beans.iterator()).hasNext()) {
                BeanInfo bean = iterator.next();
                this.resolve(bean);
            }
            return this.beanMappings;
        }

        private BeanMapping resolve(ClassTypeInfo classType) {
            BeanInfo bean = this.beanClassTypeMap.get(classType);
            if (bean != null) {
                return this.resolve(bean);
            }
            return null;
        }

        private BeanMapping resolve(BeanInfo bean) {
            BeanMapping mapping = this.beanMappings.get(bean);
            if (mapping == null && this.beans.remove(bean)) {
                mapping = this.create(bean);
                this.beanMappings.put(bean, mapping);
                this.build(mapping);
            }
            return mapping;
        }

        private BeanMapping create(BeanInfo bean) {
            boolean abstract_;
            boolean orderable;
            String nodeTypeName;
            NodeTypeKind nodeTypeKind;
            Collection<? extends Annotation> annotations = bean.getAnnotations(PrimaryType.class, MixinType.class);
            if (annotations.size() != 1) {
                throw new InvalidMappingException(bean.getClassType(), "Class is not annotated with a primary type of mixin type");
            }
            Annotation mappingAnnotation = annotations.iterator().next();
            NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
            NamingPolicy namingPolicy = bean.getAnnotation(NamingPolicy.class);
            if (namingPolicy != null) {
                onDuplicate = namingPolicy.onDuplicate();
            }
            ClassTypeInfo formatter = null;
            AnnotationInfo formattedBy = (AnnotationInfo)bean.getAnnotation(BeanMappingBuilder.this.FORMATTED_BY_ANNOTATION_TYPE);
            if (formattedBy != null) {
                AnnotationParameterInfo valueParameter = formattedBy.getParameter("value");
                formatter = (ClassTypeInfo)valueParameter.getValue();
            }
            NamingPrefix namingPrefix = bean.getAnnotation(NamingPrefix.class);
            String prefix = null;
            if (namingPrefix != null) {
                prefix = namingPrefix.value();
            }
            if (mappingAnnotation instanceof PrimaryType) {
                PrimaryType typeAnnotation = (PrimaryType)mappingAnnotation;
                nodeTypeKind = NodeTypeKind.PRIMARY;
                nodeTypeName = typeAnnotation.name();
                orderable = typeAnnotation.orderable();
                abstract_ = typeAnnotation.abstract_();
            } else {
                MixinType typeAnnotation = (MixinType)mappingAnnotation;
                nodeTypeKind = NodeTypeKind.MIXIN;
                nodeTypeName = typeAnnotation.name();
                orderable = false;
                abstract_ = true;
            }
            return new BeanMapping(bean, nodeTypeKind, nodeTypeName, onDuplicate, formatter, orderable, abstract_, prefix);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void build(BeanMapping beanMapping) {
            ClassTypeInfo argCTI;
            TypeInfo argTI;
            List parameterTypes;
            MethodInfo method;
            BeanInfo bean = beanMapping.bean;
            if (bean.getParent() != null) {
                beanMapping.parent = this.resolve(bean.getParent());
            }
            HashMap<String, void> properties = new HashMap<String, void>();
            for (PropertyInfo propertyInfo : bean.getProperties().values()) {
                void var7_10;
                Collection<Annotation> annotations = propertyInfo.getAnnotations(Property.class, Properties.class, OneToOne.class, OneToMany.class, ManyToOne.class, Id.class, Path.class, Name.class, WorkspaceName.class);
                if (annotations.size() > 1) {
                    throw new InvalidMappingException(bean.getClassType(), "The property " + propertyInfo + " declares too many annotations " + annotations);
                }
                Object var7_11 = null;
                if (annotations.size() == 1) {
                    PropertyInfo a;
                    Property propertyAnnotation;
                    SimpleValueInfo simpleValue;
                    Annotation annotation = annotations.iterator().next();
                    Object value = propertyInfo.getValue();
                    if (propertyInfo.getValueKind() == ValueKind.SINGLE) {
                        if (value instanceof SimpleValueInfo) {
                            simpleValue = (SimpleValueInfo)value;
                            if (annotation instanceof Property) {
                                propertyAnnotation = (Property)annotation;
                                if (simpleValue.getValueKind() instanceof ValueKind.Single) {
                                    a = propertyInfo;
                                    ValueMapping valueMapping = this.createValueMapping(propertyAnnotation, a);
                                } else {
                                    a = propertyInfo;
                                    ValueMapping valueMapping = this.createValueMapping(propertyAnnotation, a);
                                }
                            } else if (annotation instanceof Id) {
                                AttributeMapping attributeMapping = this.createAttribute(propertyInfo, NodeAttributeType.ID);
                            } else if (annotation instanceof Path) {
                                AttributeMapping attributeMapping = this.createAttribute(propertyInfo, NodeAttributeType.PATH);
                            } else if (annotation instanceof Name) {
                                AttributeMapping attributeMapping = this.createAttribute(propertyInfo, NodeAttributeType.NAME);
                            } else {
                                if (!(annotation instanceof WorkspaceName)) throw new InvalidMappingException(bean.getClassType(), "The property " + propertyInfo + " is not annotated");
                                AttributeMapping attributeMapping = this.createAttribute(propertyInfo, NodeAttributeType.WORKSPACE_NAME);
                            }
                        } else {
                            if (!(value instanceof BeanValueInfo)) throw new AssertionError();
                            if (annotation instanceof OneToOne) {
                                OneToOne oneToOne = (OneToOne)annotation;
                                switch (oneToOne.type()) {
                                    case HIERARCHIC: {
                                        RelationshipMapping.OneToOne.Hierarchic hierarchic = this.createHierarchicOneToOne(beanMapping, oneToOne, propertyInfo);
                                        break;
                                    }
                                    case EMBEDDED: {
                                        RelationshipMapping.OneToOne.Embedded embedded = this.createEmbeddedOneToOne(propertyInfo);
                                        break;
                                    }
                                    default: {
                                        throw new InvalidMappingException(bean.getClassType(), "Expecting that the @OneToOne property " + propertyInfo + " to be annotated with " + RelationshipType.HIERARCHIC + " or " + RelationshipType.EMBEDDED + " instead of " + oneToOne.type());
                                    }
                                }
                            } else {
                                if (!(annotation instanceof ManyToOne)) throw new InvalidMappingException(bean.getClassType(), "Annotation " + annotation + " is forbidden " + " on property " + propertyInfo);
                                ManyToOne manyToOne = (ManyToOne)annotation;
                                switch (manyToOne.type()) {
                                    case HIERARCHIC: {
                                        RelationshipMapping.ManyToOne.Hierarchic hierarchic = this.createHierarchicManyToOne(beanMapping, manyToOne, propertyInfo);
                                        break;
                                    }
                                    case PATH: 
                                    case REFERENCE: {
                                        RelationshipMapping.ManyToOne.Reference reference = this.createReferenceManyToOne(manyToOne, propertyInfo);
                                        break;
                                    }
                                    default: {
                                        throw new InvalidMappingException(bean.getClassType(), "Expecting that the @ManyToOne property " + propertyInfo + " to be annotated with " + RelationshipType.HIERARCHIC + ", " + RelationshipType.PATH + " or " + RelationshipType.REFERENCE + " instead of " + manyToOne.type());
                                    }
                                }
                            }
                        }
                    } else {
                        if (!(propertyInfo.getValueKind() instanceof ValueKind.Multi)) throw new AssertionError();
                        if (value instanceof SimpleValueInfo) {
                            simpleValue = (SimpleValueInfo)value;
                            if (annotation instanceof Property) {
                                propertyAnnotation = (Property)annotation;
                                if (simpleValue.getValueKind() instanceof ValueKind.Single) {
                                    a = propertyInfo;
                                    ValueMapping valueMapping = this.createValueMapping(propertyAnnotation, a);
                                } else {
                                    a = propertyInfo;
                                    ValueMapping valueMapping = this.createValueMapping(propertyAnnotation, a);
                                }
                            } else {
                                if (!(annotation instanceof Properties)) throw new InvalidMappingException(bean.getClassType(), "Annotation " + annotation + " is forbidden " + " on property " + propertyInfo);
                                PropertiesMapping<SimpleValueInfo> propertiesMapping = this.createProperties(propertyInfo);
                            }
                        } else {
                            if (!(value instanceof BeanValueInfo)) throw new AssertionError();
                            if (annotation instanceof OneToMany) {
                                OneToMany oneToMany = (OneToMany)annotation;
                                switch (oneToMany.type()) {
                                    case HIERARCHIC: {
                                        RelationshipMapping.OneToMany.Hierarchic hierarchic = this.createHierarchicOneToMany(beanMapping, oneToMany, propertyInfo);
                                        break;
                                    }
                                    case PATH: 
                                    case REFERENCE: {
                                        RelationshipMapping.OneToMany.Reference reference = this.createReferenceOneToMany(oneToMany, propertyInfo);
                                        break;
                                    }
                                    default: {
                                        throw new InvalidMappingException(bean.getClassType(), "Expecting that the @OneToMany property " + propertyInfo + " to be annotated with " + RelationshipType.HIERARCHIC + ", " + RelationshipType.PATH + " or " + RelationshipType.REFERENCE + " instead of " + oneToMany.type());
                                    }
                                }
                            } else {
                                if (!(annotation instanceof Properties)) throw new InvalidMappingException(bean.getClassType(), "Annotation " + annotation + " is forbidden " + " on property " + propertyInfo);
                                PropertiesMapping<SimpleValueInfo> propertiesMapping = this.createProperties(propertyInfo);
                            }
                        }
                    }
                }
                if (var7_10 == null) continue;
                PropertyInfo parentProperty = propertyInfo.getParent();
                if (parentProperty != null) {
                    BeanInfo ancestor = parentProperty.getOwner();
                    BeanMapping ancestorMapping = this.resolve(ancestor);
                    var7_10.parent = ancestorMapping.properties.get(parentProperty.getName());
                }
                properties.put(((PropertyInfo)var7_10.property).getName(), var7_10);
            }
            beanMapping.properties.putAll(properties);
            for (PropertyMapping propertyMapping : beanMapping.properties.values()) {
                propertyMapping.owner = beanMapping;
            }
            MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL);
            HashSet<MethodMapping> hashSet = new HashSet<MethodMapping>();
            for (AnnotationTarget annotationTarget : introspector.resolveMethods(bean.getClassType(), Constants.CREATE)) {
                ClassTypeInfo returnTypeInfo;
                method = (MethodInfo)annotationTarget.getTarget();
                if (method.isStatic()) throw new InvalidMappingException(bean.getClassType(), "The @Create method " + method + " must not be static");
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() >= 2) throw new InvalidMappingException(bean.getClassType(), "The signature of the @Create method " + method + "should have zero or one argument instead of " + method.getSignature());
                if (parameterTypes.size() == 1) {
                    argTI = (TypeInfo)parameterTypes.get(0);
                    if (!(argTI instanceof ClassTypeInfo)) throw new InvalidMappingException(bean.getClassType(), "The argument of the @Create method " + method + " must be a java.lang.String instead of " + method.getSignature());
                    argCTI = (ClassTypeInfo)argTI;
                    if (!argCTI.getName().equals(String.class.getName())) {
                        throw new InvalidMappingException(bean.getClassType(), "The argument of the @Create method " + method + " must be a java.lang.String instead of " + method.getSignature());
                    }
                }
                if ((returnTypeInfo = bean.resolveToClass(method.getReturnType())) == null) throw new InvalidMappingException(bean.getClassType(), "Invalid @Create method " + method + " return type " + returnTypeInfo);
                BeanMapping createBeanMapping = this.resolve(returnTypeInfo);
                if (createBeanMapping == null) {
                    throw new InvalidMappingException(bean.getClassType(), "Could not resolve the return type " + returnTypeInfo + " to a chromattic bean among beans " + this.beans + " and mappings " + this.beanMappings.values());
                }
                hashSet.add(new CreateMapping(method, createBeanMapping));
            }
            for (AnnotationTarget annotationTarget : introspector.resolveMethods(bean.getClassType(), Constants.DESTROY)) {
                method = (MethodInfo)annotationTarget.getTarget();
                if (method.isStatic()) throw new InvalidMappingException(bean.getClassType(), "The @Destroy method " + method + " must not be static");
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() != 0) {
                    throw new InvalidMappingException(bean.getClassType(), "The @Destroy method " + method + " must have no arguments");
                }
                if (!(method.getReturnType() instanceof VoidTypeInfo)) {
                    throw new InvalidMappingException(bean.getClassType(), "The @Destroy method " + method + " must have a void return type");
                }
                hashSet.add(new DestroyMapping(method));
            }
            for (AnnotationTarget annotationTarget : introspector.resolveMethods(bean.getClassType(), Constants.FIND_BY_ID)) {
                method = (MethodInfo)annotationTarget.getTarget();
                if (method.isStatic()) throw new InvalidMappingException(bean.getClassType(), "The @FindById method " + method + " must not be static");
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() != 1) throw new InvalidMappingException(bean.getClassType(), "The signature of the @FindById method " + method + "should a single java.lang.String argument instead of " + method.getSignature());
                argTI = (TypeInfo)parameterTypes.get(0);
                if (!(argTI instanceof ClassTypeInfo)) throw new InvalidMappingException(bean.getClassType(), "The argument of the @FindById method " + method + " must be a java.lang.String instead of " + method.getSignature());
                argCTI = (ClassTypeInfo)argTI;
                if (!argCTI.getName().equals(String.class.getName())) throw new InvalidMappingException(bean.getClassType(), "The argument of the @FindById method " + method + " must be a java.lang.String instead of " + method.getSignature());
                ClassTypeInfo cti = (ClassTypeInfo)bean.getClassType().resolve(method.getReturnType());
                hashSet.add(new FindByIdMapping(method, cti));
            }
            beanMapping.methods.addAll(hashSet);
        }

        private AttributeMapping createAttribute(PropertyInfo<SimpleValueInfo, ValueKind.Single> property, NodeAttributeType type) {
            TypeInfo effectiveType = property.getValue().getEffectiveType();
            if (!(effectiveType instanceof ClassTypeInfo)) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "The property " + property + " must be of type java.lang.String");
            }
            ClassTypeInfo effectiveClassType = (ClassTypeInfo)effectiveType;
            if (!effectiveClassType.getName().equals(String.class.getName())) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "The property " + property + " must be of type java.lang.String");
            }
            return new AttributeMapping(property, type);
        }

        private <V extends ValueInfo> PropertiesMapping<V> createProperties(PropertyInfo<V, ValueKind.Map> property) {
            ValueKind.Single valueKind;
            if (property.getValueKind() != ValueKind.MAP) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "The @Properties " + property + " must be of type java.util.Map instead of " + ((ValueInfo)property.getValue()).getEffectiveType());
            }
            TypeInfo type = ((ValueInfo)property.getValue()).getEffectiveType();
            PropertyMetaType<?> mt = null;
            V vi = property.getValue();
            if (vi instanceof SimpleValueInfo) {
                SimpleValueInfo svi = (SimpleValueInfo)vi;
                if (svi.getTypeMapping() != null) {
                    mt = svi.getTypeMapping().getPropertyMetaType();
                }
                valueKind = svi.getValueKind();
            } else {
                if (type.getName().equals(Object.class.getName())) {
                    mt = null;
                }
                valueKind = ValueKind.SINGLE;
            }
            String prefix = null;
            NamingPrefix namingPrefix = property.getAnnotation(NamingPrefix.class);
            if (namingPrefix != null) {
                prefix = namingPrefix.value();
            }
            return new PropertiesMapping<V>(property, prefix, mt, valueKind);
        }

        private <K extends ValueKind> ValueMapping<K> createValueMapping(Property propertyAnnotation, PropertyInfo<SimpleValueInfo<K>, ValueKind.Single> property) {
            PropertyMetaType<?> propertyMetaType = PropertyMetaType.get(propertyAnnotation.type());
            SimpleTypeMapping resolved = this.typeResolver.resolveType(property.getValue().getDeclaredType(), propertyMetaType);
            if (resolved == null) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "No simple type mapping " + property.getValue().getDeclaredType() + " for property " + property);
            }
            List<String> defaultValueList = null;
            DefaultValue defaultValueAnnotation = property.getAnnotation(DefaultValue.class);
            if (defaultValueAnnotation != null) {
                String[] defaultValues = defaultValueAnnotation.value();
                defaultValueList = new ArrayList<String>(defaultValues.length);
                defaultValueList.addAll(Arrays.asList(defaultValues));
                defaultValueList = java.util.Collections.unmodifiableList(defaultValueList);
            }
            PropertyDefinitionMapping propertyDefinition = new PropertyDefinitionMapping(propertyAnnotation.name(), resolved.getPropertyMetaType(), defaultValueList, false);
            return new ValueMapping<K>(property, propertyDefinition);
        }

        private RelationshipMapping.OneToMany.Reference createReferenceOneToMany(OneToMany annotation, PropertyInfo<BeanValueInfo, ?> property) {
            MappedBy mappedBy = property.getAnnotation(MappedBy.class);
            if (mappedBy == null) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "The reference @OneToMany relationship " + property + "must carry an @MappedBy annotation");
            }
            RelationshipMapping.OneToMany.Reference mapping = new RelationshipMapping.OneToMany.Reference(property, mappedBy.value(), annotation.type());
            mapping.relatedBeanMapping = this.resolve(property.getValue().getBean());
            return mapping;
        }

        private RelationshipMapping.OneToMany.Hierarchic createHierarchicOneToMany(BeanMapping beanMapping, OneToMany annotation, PropertyInfo<BeanValueInfo, ?> property) {
            NamingPrefix namingPrefix = property.getAnnotation(NamingPrefix.class);
            String declaredPrefix = namingPrefix != null ? namingPrefix.value() : null;
            String prefix = declaredPrefix == null ? beanMapping.getPrefix() : declaredPrefix;
            RelationshipMapping.OneToMany.Hierarchic mapping = new RelationshipMapping.OneToMany.Hierarchic(property, declaredPrefix, prefix);
            mapping.relatedBeanMapping = this.resolve(property.getValue().getBean());
            return mapping;
        }

        private RelationshipMapping.ManyToOne.Reference createReferenceManyToOne(ManyToOne annotation, PropertyInfo<BeanValueInfo, ValueKind.Single> property) {
            MappedBy mappedBy = property.getAnnotation(MappedBy.class);
            if (mappedBy == null) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "The reference @ManyToOne relationship " + property + "must carry an @MappedBy annotation");
            }
            RelationshipMapping.ManyToOne.Reference mapping = new RelationshipMapping.ManyToOne.Reference(property, mappedBy.value(), annotation.type());
            mapping.relatedBeanMapping = this.resolve(property.getValue().getBean());
            return mapping;
        }

        private RelationshipMapping.ManyToOne.Hierarchic createHierarchicManyToOne(BeanMapping beanMapping, ManyToOne annotation, PropertyInfo<BeanValueInfo, ValueKind.Single> property) {
            NamingPrefix namingPrefix = property.getAnnotation(NamingPrefix.class);
            String declaredPrefix = namingPrefix != null ? namingPrefix.value() : null;
            String prefix = declaredPrefix == null ? beanMapping.getPrefix() : declaredPrefix;
            RelationshipMapping.ManyToOne.Hierarchic mapping = new RelationshipMapping.ManyToOne.Hierarchic(property, declaredPrefix, prefix);
            mapping.relatedBeanMapping = this.resolve(property.getValue().getBean());
            return mapping;
        }

        private RelationshipMapping.OneToOne.Embedded createEmbeddedOneToOne(PropertyInfo<BeanValueInfo, ValueKind.Single> property) {
            boolean owner = property.getAnnotation(Owner.class) != null;
            RelationshipMapping.OneToOne.Embedded mapping = new RelationshipMapping.OneToOne.Embedded(property, owner);
            mapping.relatedBeanMapping = this.resolve(property.getValue().getBean());
            return mapping;
        }

        private RelationshipMapping.OneToOne.Hierarchic createHierarchicOneToOne(BeanMapping beanMapping, OneToOne annotation, PropertyInfo<BeanValueInfo, ValueKind.Single> property) {
            String localName;
            String declaredPrefix;
            MappedBy mappedBy = property.getAnnotation(MappedBy.class);
            if (mappedBy == null) {
                throw new InvalidMappingException(property.getOwner().getClassType(), "The @OneToOne relationship " + property + "must carry an @MappedBy annotation");
            }
            boolean owner = property.getAnnotation(Owner.class) != null;
            boolean autocreated = property.getAnnotation(AutoCreated.class) != null;
            boolean mandatory = property.getAnnotation(Mandatory.class) != null;
            int index = mappedBy.value().indexOf(58);
            if (index == -1) {
                declaredPrefix = null;
                localName = mappedBy.value();
            } else {
                declaredPrefix = mappedBy.value().substring(0, index);
                localName = mappedBy.value().substring(index + 1);
            }
            String prefix = declaredPrefix == null ? beanMapping.getPrefix() : declaredPrefix;
            RelationshipMapping.OneToOne.Hierarchic mapping = new RelationshipMapping.OneToOne.Hierarchic(property, owner, declaredPrefix, prefix, localName, mandatory, autocreated);
            mapping.relatedBeanMapping = this.resolve(property.getValue().getBean());
            return mapping;
        }
    }
}

