/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JDOMMessageHandler;
import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.MessageNotSupportedException;
import java.util.HashMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xml.sax.Attributes;

public class JDOMXMessageHandler
extends JDOMMessageHandler {
    private HashMap xMsgs;
    private Element rootElem;
    private Element curElem;
    private boolean process;

    public JDOMXMessageHandler(JabberMessageParser msgParser) {
        super(msgParser);
    }

    public HashMap getXMessages() {
        return this.xMsgs;
    }

    public void startMessage() {
        super.startMessage();
        this.rootElem = null;
        this.curElem = null;
        this.process = false;
        this.xMsgs = new HashMap();
    }

    public void endMessage() {
        super.endMessage();
        this.getMessage().setXMessages(this.xMsgs);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        if (!this.process && !localName.equals("x")) {
            super.startElement(namespaceURI, localName, qName, attr);
            return;
        }
        if (localName.equals("x")) {
            this.process = true;
        }
        Element elem = new Element(localName, namespaceURI);
        int i = 0;
        while (i < attr.getLength()) {
            String attrQName = attr.getQName(i);
            String attrPrefix = attrQName.lastIndexOf(":") != -1 ? attrQName.substring(0, attrQName.lastIndexOf(":")) : "";
            Attribute att = new Attribute(attr.getLocalName(i), attr.getValue(i), Namespace.getNamespace((String)attrPrefix, (String)attr.getURI(i)));
            elem.setAttribute(att);
            ++i;
        }
        if (this.rootElem == null) {
            this.curElem = this.rootElem = elem;
        } else {
            this.curElem.addContent(elem);
            this.curElem = elem;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.process && localName.equals("x")) {
            JabberMessage msg;
            try {
                msg = this.getMessageParser().createMessage(this.rootElem.getQualifiedName(), this.rootElem.getNamespace(), this.rootElem);
            }
            catch (MessageNotSupportedException ex) {
                msg = new JabberJDOMMessage(this.rootElem);
            }
            this.xMsgs.put(this.rootElem.getNamespace().getURI(), msg);
            this.curElem = null;
            this.rootElem = null;
            this.process = false;
        } else if (this.process) {
            this.curElem = this.curElem.getParent();
        } else {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        super.characters(ch, start, length);
        if (this.process) {
            this.curElem.addContent(new String(ch, start, length));
        }
    }
}

