/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JabberChatMessage;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberPresenceMessage;

public class JabberChatService {
    private JabberContext context;
    private JabberConnection connection;

    public JabberChatService(JabberConnection connection, JabberContext context) {
        this.connection = connection;
        this.context = context;
    }

    public void sendPrivateMessage(String toJID, String body) throws SendMessageFailedException {
        JabberChatMessage msg = new JabberChatMessage("chat");
        msg.setTo(toJID);
        msg.setBody(body);
        this.connection.send(msg);
    }

    public void replyToPrivateMessage(String toJID, String threadID, String body) throws SendMessageFailedException {
        JabberChatMessage msg = new JabberChatMessage("chat");
        msg.setTo(toJID);
        msg.setBody(body);
        msg.setThreadID(threadID);
        this.connection.send(msg);
    }

    public void joinChatRoom(String roomJID, String nick) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage();
        msg.setTo(roomJID + "/" + nick);
        this.connection.send(msg);
    }

    public void leaveChatRoom(String roomJID) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("unavailable");
        msg.setTo(roomJID);
        this.connection.send(msg);
    }

    public void sendChatMessage(String roomJID, String body) throws SendMessageFailedException {
        JabberChatMessage msg = new JabberChatMessage("groupchat");
        msg.setTo(roomJID);
        msg.setBody(body);
        this.connection.send(msg);
    }

    public void setChatAvailable(String roomJID, String showState, String status) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("available");
        msg.setPriority("1");
        msg.setTo(roomJID);
        if (showState != null) {
            msg.setShowState(showState);
        }
        if (status != null) {
            msg.setStatus(status);
        } else {
            msg.setStatus("Online");
        }
        this.connection.send(msg);
    }
}

