/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.menu;

import java.util.LinkedHashMap;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.CommandItem;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.DelimiterItem;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.MenuBarItem;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.MenuItem;
import org.exoplatform.gwtframework.ui.client.component.menu.event.GWTMenuItemSelectedEvent;
import org.exoplatform.gwtframework.ui.client.component.menu.event.GWTMenuItemSelectedHandler;
import org.exoplatform.gwtframework.ui.client.component.menu.event.UpdateMainMenuEvent;
import org.exoplatform.gwtframework.ui.client.component.menu.event.UpdateMainMenuHandler;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class GWTMenuBarPresenter implements UpdateMainMenuHandler, GWTMenuItemSelectedHandler
{

   public interface Display
   {

      void buildMenu(LinkedHashMap<String, MenuBarItem> menuBarItems);

      void closeMenu();

   }

   private HandlerManager eventBus;

   private Display display;

   private Handlers handlers;

   private HandlerRegistration gwtMenuItemSelectedHandler;

   protected boolean menuEventsHandled = false;

   public GWTMenuBarPresenter(HandlerManager eventBus)
   {
      this.eventBus = eventBus;
      handlers = new Handlers(eventBus);
   }

   public void bindDisplay(Display d)
   {
      display = d;
      handlers.addHandler(UpdateMainMenuEvent.TYPE, this);
   }

   public void startHandlePopupMenuEvents()
   {
      gwtMenuItemSelectedHandler = eventBus.addHandler(GWTMenuItemSelectedEvent.TYPE, this);
      menuEventsHandled = true;
   }

   public void stopHandlePopupMenuEvents()
   {
      gwtMenuItemSelectedHandler.removeHandler();
      menuEventsHandled = false;
   }

   public boolean isMenuEventsHandled()
   {
      return menuEventsHandled;
   }

   public void onUpdateMainMenu(UpdateMainMenuEvent event)
   {
      LinkedHashMap<String, MenuBarItem> menuBarItems = new LinkedHashMap<String, MenuBarItem>();

      for (Control command : event.getCommands())
      {
         try
         {
            if (command instanceof SimpleControl)
            {
               registerItem(menuBarItems, command.getId(), (SimpleControl)command);
            }
         }
         catch (Exception exc)
         {
            exc.printStackTrace();
         }
      }

      display.buildMenu(menuBarItems);
   }

   private void registerItem(LinkedHashMap<String, MenuBarItem> menuBarItems, String workingId, SimpleControl command)
   {
      if (workingId.indexOf("/") < 0)
      {
         // this is menu bar item
         MenuBarItem item = new MenuBarItem(workingId, command);
         menuBarItems.put(workingId, item);
      }
      else
      {
         /*
          * INIT MENU BAR
          */
         String menuBarTitle = workingId.substring(0, workingId.indexOf("/"));

         MenuBarItem menuBarItem = menuBarItems.get(menuBarTitle);
         if (menuBarItem == null)
         {
            menuBarItem = new MenuBarItem(menuBarTitle, null);
            menuBarItems.put(menuBarTitle, menuBarItem);
         }

         workingId = workingId.substring(workingId.indexOf("/") + 1);

         /*
          * INIT POPUP MENU ITEM
          */

         if (workingId.indexOf("/") >= 0)
         {
            String title = workingId.substring(0, workingId.indexOf("/"));
            workingId = workingId.substring(workingId.indexOf("/") + 1);

            CommandItem commandItem = (CommandItem)getCommandItem(menuBarItem.getChildren(), title);
            if (commandItem == null)
            {
               commandItem = new CommandItem(title, menuBarItem);
               menuBarItem.getChildren().add(commandItem);
            }

            if (command.hasDelimiterBefore())
            {
               DelimiterItem delimiter = new DelimiterItem();
               commandItem.getChildren().add(delimiter);
            }

            CommandItem popup2 = new CommandItem(command, commandItem);
            commandItem.getChildren().add(popup2);
         }
         else
         {
            if (command.hasDelimiterBefore())
            {
               DelimiterItem delimiter = new DelimiterItem();
               menuBarItem.getChildren().add(delimiter);
            }

            CommandItem commandItem = new CommandItem(command, menuBarItem);
            menuBarItem.getChildren().add(commandItem);
         }
      }
   }

   private MenuItem getCommandItem(List<MenuItem> items, String title)
   {
      for (MenuItem item : items)
      {
         if (item instanceof CommandItem)
         {
            if (title.equals(((CommandItem)item).getTitle()))
            {
               return item;
            }
         }
      }

      return null;
   }

   public void onGWTMenuItemSelected(GWTMenuItemSelectedEvent event)
   {
      display.closeMenu();

      if (event.getControl() == null)
      {
         return;
      }

      if (event.getControl() instanceof SimpleControl)
      {
         SimpleControl control = (SimpleControl)event.getControl();
         if (control.canBeSelected())
         {
            control.setSelected(!control.isSelected());
         }
      }

      if (event.getControl().getEvent() != null)
      {
         eventBus.fireEvent(event.getControl().getEvent());
      }
   }

}
