/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.toolbar.component;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.ControlStateListener;
import org.exoplatform.gwtframework.ui.client.component.command.PopupMenuControl;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.lock.LockLayer;
import org.exoplatform.gwtframework.ui.client.component.lock.LockLayerClickedHandler;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.CommandItem;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.DelimiterItem;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.MenuItem;
import org.exoplatform.gwtframework.ui.client.component.menu.bean.MenuItemStateListener;
import org.exoplatform.gwtframework.ui.client.component.menu.event.GWTMenuItemSelectedEvent;
import org.exoplatform.gwtframework.ui.client.component.menu.event.GWTMenuItemSelectedHandler;
import org.exoplatform.gwtframework.ui.client.component.menu.popup.GWTPopupMenu;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbar;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarPopupMenu extends Composite implements ToolbarControl, ControlStateListener,
   LockLayerClickedHandler, GWTMenuItemSelectedHandler, MenuItemStateListener
{

   public static interface Style
   {

      static final String BUTTON_PANEL_LEFT = "exo-toolbar16PopupButtonPanel_Left";

      static final String BUTTON_PANEL_LEFT_HIDDEN = "exo-toolbar16PopupButtonPanel_LeftHidden";

      static final String BUTTON_PANEL_RIGHT = "exo-toolbar16PopupButtonPanel_Right";

      static final String BUTTON_PANEL_RIGHT_HIDDEN = "exo-toolbar16PopupButtonPanel_RightHidden";

      static final String POPUP_BUTTON = "exo-toolbar16PopupButton";

      static final String POPUP_BUTTON_OVER = "exo-toolbar16PopupButtonOver";

      static final String POPUP_BUTTON_DOWN = "exo-toolbar16PopupButtonDown";

      static final String BUTTON_ICON = "exo-toolbar16Icon";

   }

   private final static String DISABLED_SUFFIX = "_Disabled";

   private HandlerManager eventBus;

   private PopupMenuControl command;

   private boolean rightDocking;

   private GWTToolbar toolbar;

   private SimplePanel simplePanel;

   private String iconNormal;

   private String iconDisabled;

   private ButtonPanel button;

   private boolean pressed = false;

   private HandlerRegistration gwtMenuItemSelectedHandler;

   private List<MenuItem> popupMenuItems;

   public ToolbarPopupMenu(HandlerManager eventBus, PopupMenuControl command, boolean rightDocking, GWTToolbar toolbar)
   {
      this.eventBus = eventBus;
      this.command = command;
      this.rightDocking = rightDocking;
      this.toolbar = toolbar;

      setIcon(command.getIcon());

      simplePanel = new SimplePanel();
      updateVisibility();
      initWidget(simplePanel);
      setTitle(command.getPrompt());

      createPopupButton();

      fillPopupMenuItems();

      command.getStateListeners().add(this);
   }

   private void fillPopupMenuItems()
   {
      popupMenuItems = new ArrayList<MenuItem>();
      for (SimpleControl c : command.getCommands())
      {
         if (c.hasDelimiterBefore())
         {
            DelimiterItem delimiter = new DelimiterItem();
            popupMenuItems.add(delimiter);
         }
         popupMenuItems.add(new CommandItem(c, this));
      }
   }

   private void setIcon(String icon)
   {
      if (command.getIcon() == null)
      {
         return;
      }
      iconNormal = icon;
      iconDisabled = iconNormal.substring(0, iconNormal.lastIndexOf("."));
      iconDisabled += DISABLED_SUFFIX;
      iconDisabled += iconNormal.substring(iconNormal.lastIndexOf("."));
   }

   private void updateVisibility()
   {
      if (command.isVisible())
      {
         simplePanel.setStyleName(rightDocking ? Style.BUTTON_PANEL_RIGHT : Style.BUTTON_PANEL_LEFT);
      }
      else
      {
         simplePanel.setStyleName(rightDocking ? Style.BUTTON_PANEL_RIGHT_HIDDEN : Style.BUTTON_PANEL_LEFT_HIDDEN);
      }
   }

   //   private String getImageHTML()
   //   {
   //      return "<img class=\"" + Style.BUTTON_ICON + "\" src=\"" + (command.isEnabled() ? iconNormal : iconDisabled)
   //         + "\" >";
   //   }

   private Image getImage()
   {
      Image image = null;
      if (command.isEnabled())
      {
         if (command.getNormalImage() != null)
         {
            image = new Image(command.getNormalImage());
         }
         else
         {
            image = new Image(command.getIcon());
         }
      }
      else
      {
         if (command.getDisabledImage() != null)
         {
            image = new Image(command.getDisabledImage());
         }
         else
         {
            image = new Image(command.getIcon());
         }
      }

      image.setStyleName(Style.BUTTON_ICON);
      return image;
   }

   private void createPopupButton()
   {
      button = new ButtonPanel();
      button.setStyleName(Style.POPUP_BUTTON);

      //DOM.setInnerHTML(button.getElement(), getImageHTML());
      button.add(getImage());

      simplePanel.add(button);
   }

   public void updateControlEnabling(boolean enabled)
   {
      button.setStyleName(Style.POPUP_BUTTON);

      button.clear();
      button.add(getImage());

      //DOM.setInnerHTML(button.getElement(), getImageHTML());
   }

   public void updateControlIcon(String icon)
   {
   }

   public void updateControlPrompt(String prompt)
   {
      setTitle(prompt);
   }

   public void updateControlVisibility(boolean visible)
   {
      updateVisibility();
      toolbar.checkDelimiters();
   }

   protected void onMouseOver()
   {
      pressed = false;
      button.setStyleName(Style.POPUP_BUTTON_OVER);
   }

   protected void onMouseOut()
   {
      if (lockLayer != null)
      {
         return;
      }
      button.setStyleName(Style.POPUP_BUTTON);
   }

   protected void onMouseDown()
   {
      pressed = true;
      button.setStyleName(Style.POPUP_BUTTON_DOWN);
   }

   protected void onMouseUp()
   {
      if (pressed)
      {
         pressed = false;
         showPopupMenu();
      }
   }

   public boolean isControlVisible()
   {
      return command.isVisible();
   }

   private class ButtonPanel extends SimplePanel
   {

      public ButtonPanel()
      {
         sinkEvents(Event.ONMOUSEOVER | Event.ONMOUSEOUT | Event.ONMOUSEDOWN | Event.ONMOUSEUP);
      }

      @Override
      public void onBrowserEvent(Event event)
      {
         if (!command.isEnabled())
         {
            return;
         }

         switch (DOM.eventGetType(event))
         {
            case Event.ONMOUSEOVER :
               onMouseOver();
               break;

            case Event.ONMOUSEOUT :
               onMouseOut();
               break;

            case Event.ONMOUSEDOWN :
               onMouseDown();
               break;

            case Event.ONMOUSEUP :
               onMouseUp();
               break;
         }
      }

   }

   private LockLayer lockLayer;

   /**
    * Locking screen
    */
   private void lockScreen()
   {
      if (lockLayer != null)
      {
         return;
      }

      lockLayer = new LockLayer(Window.getClientWidth(), Window.getClientHeight(), this);
      RootPanel.get().add(lockLayer, 0, 0);
   }

   private void showPopupMenu()
   {
      lockScreen();

      GWTPopupMenu popupMenu = new GWTPopupMenu(eventBus, popupMenuItems, lockLayer, null);
      if (!rightDocking)
      {
         lockLayer.add(popupMenu, getAbsoluteLeft() + 4, getAbsoluteTop() + 26);
      }
      else
      {
         lockLayer.add(popupMenu, getAbsoluteLeft(), getAbsoluteTop() + 26);
         int popupMenuWidth = popupMenu.getOffsetWidth();
         if (getAbsoluteLeft() + popupMenuWidth > Window.getClientWidth())
         {
            int left = getAbsoluteLeft() - popupMenuWidth + 22;
            DOM.setStyleAttribute(popupMenu.getElement(), "left", "" + left + "px");
         }
      }

      gwtMenuItemSelectedHandler = eventBus.addHandler(GWTMenuItemSelectedEvent.TYPE, this);
   }

   public void onLockLayerClicked()
   {
      closePopup();
   }

   private void closePopup()
   {
      button.setStyleName(Style.POPUP_BUTTON);
      lockLayer.removeFromParent();
      lockLayer = null;

      gwtMenuItemSelectedHandler.removeHandler();
   }

   public void onGWTMenuItemSelected(GWTMenuItemSelectedEvent event)
   {
      closePopup();
      Control command = event.getControl();
      if (command instanceof SimpleControl)
      {
         SimpleControl simpleCommand = (SimpleControl)command;
         if (simpleCommand.getEvent() != null)
         {
            eventBus.fireEvent(simpleCommand.getEvent());
         }
      }
   }

   public void updateMenuItemState()
   {
   }

}
