/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase;

import org.exoplatform.gwtframework.ui.client.ShowCasePanel;
import org.exoplatform.gwtframework.ui.client.component.ExoStyle;
import org.exoplatform.gwtframework.ui.client.component.tree.GWTTree;
import org.exoplatform.gwtframework.ui.client.component.tree.TreeRecord;
import org.exoplatform.gwtframework.ui.client.component.tree.bean.TreeNode;
import org.exoplatform.gwtframework.ui.client.showcase.cases.AutocompleteFormCase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.MenuShowcase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.NewAutocompleteFormCase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.StatusBarCase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.TreeAddDelete;
import org.exoplatform.gwtframework.ui.client.showcase.cases.TreeShowcase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.menu.MenuAndToolbarCase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar.ToolbarButtonsCase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar.ToolbarPopupButtonShowcase;
import org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar.ToolbarTextInputShowcase;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ShowcaseTreeNavigation extends Composite
{

   private interface Images
   {

      static final String IMAGES_URL = ExoStyle.getEXoStyleURL() + "../../../../showcase/images/cases/";

      static final String HOME = IMAGES_URL + "house.png";

      static final String BUTTONS = IMAGES_URL + "buttons.png";

      static final String GRIDS = IMAGES_URL + "grids.png";

      static final String TREE = IMAGES_URL + "tree.png";

      static final String CASE = IMAGES_URL + "case.png";

      static final String MENUS = IMAGES_URL + "menus.png";

   }

   private FlowPanel panel = new FlowPanel();

   private ShowCasePanel showCasePanel;

   private TestTree tree;

   private TreeNode autoForm;

   private TreeNode newAutoForm;

   public ShowcaseTreeNavigation(ShowCasePanel showCasePanel)
   {
      this.showCasePanel = showCasePanel;

      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "width", "250px");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");
      DOM.setStyleAttribute(panel.getElement(), "background", "#EE8899");

      createTree();
   }

   private void createTree()
   {
      tree = new TestTree();
      panel.add(tree);

      tree.setWidth("100%");
      tree.setHeight("100%");

      TreeNode showCase = new TreeNode("ShowCase", Images.HOME);

      showCase.getChildren().add(getButtonsCases());
      showCase.getChildren().add(getMenuCases());
      showCase.getChildren().add(getToolBarCases());
      showCase.getChildren().add(getStatusBarCases());
      showCase.getChildren().add(getTreeCases());
      showCase.getChildren().add(getAutoCompleteCases());
      showCase.getChildren().add(getGridCases());

      tree.setRoot(showCase);
   }

   /**
    * @return
    */
   private TreeNode getAutoCompleteCases()
   {
      TreeNode list = new TreeNode("Auto-completeForm", Images.GRIDS);

      autoForm = new TreeNode("Auto-complete Form", Images.GRIDS);
      autoForm.setIsFolder(false);

      newAutoForm = new TreeNode("New Auto-complete form", Images.GRIDS);
      newAutoForm.setIsFolder(false);

      list.getChildren().add(autoForm);
      list.getChildren().add(newAutoForm);

      return list;
   }

   private TreeNode getButtonsCases()
   {
      TreeNode buttons = new TreeNode("Buttons", Images.BUTTONS);

      TreeNode simpleButton = new TreeNode("Button (not implemented yet)", Images.CASE);
      simpleButton.setIsFolder(false);
      buttons.getChildren().add(simpleButton);

      return buttons;
   }

   private TreeNode simpleMenuNode;

   private TreeNode menuAndToolbarNode;

   private TreeNode getMenuCases()
   {
      TreeNode menu = new TreeNode("Menu", Images.MENUS);

      simpleMenuNode = new TreeNode("Simple menu", Images.CASE);
      simpleMenuNode.setIsFolder(false);
      menu.getChildren().add(simpleMenuNode);

      menuAndToolbarNode = new TreeNode("Menu and Toolbar", Images.CASE);
      menuAndToolbarNode.setIsFolder(false);
      menu.getChildren().add(menuAndToolbarNode);

      return menu;
   }

   private TreeNode simpleStatusBarNode;

   private TreeNode getStatusBarCases()
   {
      TreeNode statusBar = new TreeNode("StatusBar");

      simpleStatusBarNode = new TreeNode("Simple Status Bar", Images.CASE);
      simpleStatusBarNode.setIsFolder(false);
      statusBar.getChildren().add(simpleStatusBarNode);

      return statusBar;
   }

   private TreeNode toolbarTextInputNode;

   private TreeNode toolbarPopupButtonNode;

   private TreeNode toolbarButtonsNode;

   private TreeNode getToolBarCases()
   {
      TreeNode toolBar = new TreeNode("ToolBar");

      toolbarButtonsNode = new TreeNode("Buttons", Images.CASE);
      toolbarButtonsNode.setIsFolder(false);
      toolBar.getChildren().add(toolbarButtonsNode);

      toolbarPopupButtonNode = new TreeNode("Popup Button", Images.CASE);
      toolbarPopupButtonNode.setIsFolder(false);
      toolBar.getChildren().add(toolbarPopupButtonNode);

      toolbarTextInputNode = new TreeNode("Text Input", Images.CASE);
      toolbarTextInputNode.setIsFolder(false);
      toolBar.getChildren().add(toolbarTextInputNode);

      return toolBar;
   }

   private TreeNode simpleTreeNode;

   private TreeNode treeAddDeleteNode;

   private TreeNode getTreeCases()
   {
      TreeNode tree = new TreeNode("Tree", Images.TREE);

      simpleTreeNode = new TreeNode("Simple Tree", Images.CASE);
      simpleTreeNode.setIsFolder(false);
      tree.getChildren().add(simpleTreeNode);

      treeAddDeleteNode = new TreeNode("Add / Delete nodes", Images.CASE);
      treeAddDeleteNode.setIsFolder(false);
      tree.getChildren().add(treeAddDeleteNode);

      return tree;
   }

   private TreeNode getGridCases()
   {
      TreeNode grid = new TreeNode("Grid", Images.GRIDS);

      TreeNode gridCase = new TreeNode("Grid (not implemented yet)", Images.CASE);
      gridCase.setIsFolder(false);
      grid.getChildren().add(gridCase);

      return grid;
   }

   protected void rowClicked()
   {
      if (tree.getSelectedRecord() == null)
      {
         return;
      }

      TreeRecord selectedRecord = tree.getSelectedRecord();

      if (selectedRecord.getNode() == toolbarTextInputNode)
      {
         ToolbarTextInputShowcase toolbar = new ToolbarTextInputShowcase();
         showCasePanel.showCase(toolbar);
      }
      else if (selectedRecord.getNode() == toolbarPopupButtonNode)
      {
         ToolbarPopupButtonShowcase toolbar = new ToolbarPopupButtonShowcase();
         showCasePanel.showCase(toolbar);
      }
      else if (selectedRecord.getNode() == simpleMenuNode)
      {
         MenuShowcase menu = new MenuShowcase();
         showCasePanel.showCase(menu);
      }
      else if (selectedRecord.getNode() == menuAndToolbarNode)
      {
         MenuAndToolbarCase c = new MenuAndToolbarCase();
         showCasePanel.showCase(c);
      }
      else if (selectedRecord.getNode() == simpleTreeNode)
      {
         TreeShowcase tree = new TreeShowcase();
         showCasePanel.showCase(tree);
      }
      else if (selectedRecord.getNode() == simpleStatusBarNode)
      {
         StatusBarCase statusBar = new StatusBarCase();
         showCasePanel.showCase(statusBar);
      }
      else if (selectedRecord.getNode() == treeAddDeleteNode)
      {
         TreeAddDelete c = new TreeAddDelete();
         showCasePanel.showCase(c);
      }
      else if (selectedRecord.getNode() == autoForm)
      {
         AutocompleteFormCase a = new AutocompleteFormCase();
         showCasePanel.showCase(a);
      }
      else if (selectedRecord.getNode() == newAutoForm)
      {
         NewAutocompleteFormCase a = new NewAutocompleteFormCase();
         showCasePanel.showCase(a);
      }
      else if (selectedRecord.getNode() == toolbarButtonsNode)
      {
         ToolbarButtonsCase c = new ToolbarButtonsCase();
         showCasePanel.showCase(c);
      }

   }

   private class TestTree extends GWTTree
   {
      @Override
      public void onClick(TreeRecord treerecord)
      {
         rowClicked();
      }
   }

}
