/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.editor.api.Token;
import org.exoplatform.gwtframework.editor.api.Token.TokenType;
import org.exoplatform.gwtframework.ui.client.component.autocomplete.AutoCompleteForm;
import org.exoplatform.gwtframework.ui.client.component.autocomplete.AutocompleteTokenSelectedHandler;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * @author <a href="mailto:tnemov@gmail.com">Evgen Vidolob</a>
 * @version $Id: $
 *
 */
public class AutocompleteFormCase extends Composite implements AutocompleteTokenSelectedHandler
{

   private FlowPanel panel;

   private HandlerManager eventBus = new HandlerManager(null);

   public AutocompleteFormCase()
   {
      panel = new FlowPanel();
      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "background", "#FFFFFF");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");
      panel.getElement().setAttribute("style", "left: 410px; top: 5px; position: absolute;");

      List<Token> tokens = new ArrayList<Token>();

      tokens.add(new Token("break", TokenType.KEYWORD));
      tokens.add(new Token("case", TokenType.KEYWORD));
      tokens.add(new Token("catch", TokenType.KEYWORD));
      tokens.add(new Token("const", TokenType.KEYWORD));
      tokens.add(new Token("continue", TokenType.KEYWORD));
      tokens.add(new Token("default", TokenType.KEYWORD));
      tokens.add(new Token("delete", TokenType.KEYWORD));
      tokens.add(new Token("do", TokenType.KEYWORD));
      tokens.add(new Token("else", TokenType.KEYWORD));
      tokens.add(new Token("export", TokenType.KEYWORD));
      tokens.add(new Token("false", TokenType.KEYWORD));
      tokens.add(new Token("for", TokenType.KEYWORD));
      tokens.add(new Token("function", TokenType.KEYWORD));
      tokens.add(new Token("if", TokenType.KEYWORD));
      tokens.add(new Token("import", TokenType.KEYWORD));
      tokens.add(new Token("in", TokenType.KEYWORD));
      tokens.add(new Token("instanceof", TokenType.KEYWORD));
      tokens.add(new Token("label", TokenType.KEYWORD));
      tokens.add(new Token("let", TokenType.KEYWORD));
      tokens.add(new Token("new", TokenType.KEYWORD));
      tokens.add(new Token("null", TokenType.KEYWORD));
      tokens.add(new Token("return", TokenType.KEYWORD));
      tokens.add(new Token("switch", TokenType.KEYWORD));
      tokens.add(new Token("this", TokenType.KEYWORD));
      tokens.add(new Token("throw", TokenType.KEYWORD));
      tokens.add(new Token("true", TokenType.KEYWORD));
      tokens.add(new Token("try", TokenType.KEYWORD));
      tokens.add(new Token("typeof", TokenType.KEYWORD));
      tokens.add(new Token("var", TokenType.KEYWORD));
      tokens.add(new Token("void", TokenType.KEYWORD));
      tokens.add(new Token("while", TokenType.KEYWORD));
      tokens.add(new Token("with", TokenType.KEYWORD));
      tokens.add(new Token("yield", TokenType.KEYWORD));

      tokens.add(new Token("d", TokenType.VARIABLE, 0));
      tokens
         .add(new Token("for", TokenType.TEMPLATE, "for-iterate over array",
            "for (var i = 0; i < array.length; i++)\n{\n\n}",
            "<pre>for (var i = 0; i < array.length; i++)\n{\n\n}</pre>"));

      tokens.add(new Token("if", TokenType.TEMPLATE, "if-condition", "if (condition)\n{\n\n}",
         "<pre>if (condition)\n{\n\n}</pre>"));

      tokens.add(new Token("if", TokenType.TEMPLATE, "if-condition-else", "if (condition)\n{\n\n}\nelse\n{\n\n}",
         "<pre>if (condition)\n{\n\n}\nelse\n{\n\n}</pre>"));

      tokens.add(new Token("try", TokenType.TEMPLATE, "try-catch", "try\n{\n\n}\ncatch(e)\n{\n\n}",
         "<pre>try\n{\n\n}\ncatch(e)\n{\n\n}</pre>"));

      tokens
         .add(new Token("orphans", TokenType.PROPERTY, "", "",
            "Sets the minimum number of lines that must be left at the bottom of a page when a page break occurs inside an element"));

      tokens.add(new Token("doClose", TokenType.METHOD, 50));

      AutoCompleteForm af = new AutoCompleteForm(eventBus, 270, 50, "th", tokens, this);

   }

   /**
    * @see org.exoplatform.gwtframework.ui.client.component.autocomlete.AutocompleteTokenSelectedHandler#onAutocompleteTokenSelected(java.lang.String)
    */
   public void onAutocompleteTokenSelected(Token token)
   {
      Window.alert(token.getName());
   }

   /**
    * @see org.exoplatform.gwtframework.ui.client.component.autocomlete.AutocompleteTokenSelectedHandler#onAutocompleteCancel()
    */
   public void onAutocompleteCancel()
   {

      Window.alert("Auto-complete canceled");

   }
}
