/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases.menu;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.menu.GWTMenuBar;
import org.exoplatform.gwtframework.ui.client.component.menu.event.UpdateMainMenuEvent;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbarForm;
import org.exoplatform.gwtframework.ui.client.component.toolbar.event.UpdateToolbarEvent;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class MenuAndToolbarCase extends Composite
{

   private FlowPanel panel = new FlowPanel();

   private HandlerManager eventBus;

   public MenuAndToolbarCase()
   {
      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "background", "#efefef");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");

      eventBus = new HandlerManager(null);
      new Handlers(eventBus);

      createMenu();
      createToolbar();
      
      init();
   }

   private void createMenu()
   {
      GWTMenuBar menu = new GWTMenuBar(eventBus);
      panel.add(menu);
   }

   private void createToolbar()
   {
      GWTToolbarForm toolbar = new GWTToolbarForm(eventBus);
      panel.add(toolbar);
   }

   private void init()
   {
      SimpleControl testControl1 = new SimpleControl("Test/Test Control 1");
      testControl1.setImages(ShowCaseImageBundle.INSTANCE.xml() , ShowCaseImageBundle.INSTANCE.xmlDisabled());
      testControl1.setPrompt("Test Control 1");
      testControl1.setTitle("Test Control 1");
      testControl1.setEnabled(true);
      testControl1.setVisible(true);
      testControl1.setHotKey("Ctrl+A");

      SimpleControl testControl2 = new SimpleControl("Test/Test Control 2");
      testControl2.setImages(ShowCaseImageBundle.INSTANCE.groovy(), ShowCaseImageBundle.INSTANCE.groovyDisabled());
      testControl2.setPrompt("Test Control 2");
      testControl2.setTitle("Test Control 2");
      testControl2.setEnabled(true);
      testControl2.setVisible(true);
      testControl2.setCanBeSelected(true);
      testControl2.setHotKey("Ctrl+S");

      List<Control> controls = new ArrayList<Control>();
      controls.add(testControl1);
      controls.add(testControl2);
      
      List<String> toolbarItems = new ArrayList<String>();
      toolbarItems.add(testControl1.getId());
      toolbarItems.add("");
      toolbarItems.add(testControl2.getId());

      eventBus.fireEvent(new UpdateMainMenuEvent(controls));
      eventBus.fireEvent(new UpdateToolbarEvent(toolbarItems, controls));
   }

}
