/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.showcase.cases.toolbar;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.gwtframework.commons.component.Handlers;
import org.exoplatform.gwtframework.ui.client.ShowCaseImageBundle;
import org.exoplatform.gwtframework.ui.client.component.command.Control;
import org.exoplatform.gwtframework.ui.client.component.command.PopupMenuControl;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.command.builder.PopupMenuCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.command.builder.SimpleCommandBuilder;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbarForm;
import org.exoplatform.gwtframework.ui.client.component.toolbar.ToolbarItemType;
import org.exoplatform.gwtframework.ui.client.component.toolbar.event.UpdateToolbarEvent;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseEvent;
import org.exoplatform.gwtframework.ui.client.showcase.event.ShowcaseHandler;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarPopupButtonShowcase extends Composite implements ShowcaseHandler
{

   private FlowPanel panel;

   private HandlerManager eventBus;

   private Handlers handlers;

   private GWTToolbarForm toolbar;

   private SimpleControl showHidePopupButtonCommand1;

   private SimpleControl showHidePopupButtonCommand2;

   private SimpleControl enableDisablePopupButtonCommand1;

   private PopupMenuControl popupMenuCommand1;

   private PopupMenuControl popupMenuCommand2;

   private SimpleControl simpleCommand1;

   private SimpleControl simpleCommand2;

   private SimpleControl simpleCommand3;

   public ToolbarPopupButtonShowcase()
   {
      panel = new FlowPanel();
      initWidget(panel);

      DOM.setStyleAttribute(panel.getElement(), "border", "#aaaaaa 1px solid");

      DOM.setStyleAttribute(panel.getElement(), "background", "#efefef");
      DOM.setStyleAttribute(panel.getElement(), "width", "100%");
      DOM.setStyleAttribute(panel.getElement(), "height", "100%");

      eventBus = new HandlerManager(null);
      handlers = new Handlers(eventBus);
      handlers.addHandler(ShowcaseEvent.TYPE, this);

      createButtons();

      createToolbar();
   }

   private void createButtons()
   {
      showHidePopupButtonCommand1 =
         SimpleCommandBuilder.newCommand("showhide1").title("Hide left popup").prompt("Hide left popup").images(
            ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE.removeDisabled()).enable().show()
            .event(new ShowcaseEvent("hide/show left")).create();

      showHidePopupButtonCommand2 =
         SimpleCommandBuilder.newCommand("showhide2").title("Hide right popup").prompt("Hide right popup").images(
            ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE.removeDisabled()).enable().show()
            .event(new ShowcaseEvent("hide/show right")).create();

      enableDisablePopupButtonCommand1 =
         SimpleCommandBuilder.newCommand("enabledisable1").title("Disable left popup").prompt("Disable left popup")
            .images(ShowCaseImageBundle.INSTANCE.cancel(), ShowCaseImageBundle.INSTANCE.cancelDisabled()).enable()
            .show().event(new ShowcaseEvent("enable/disable left")).create();

      simpleCommand1 =
         SimpleCommandBuilder.newCommand("newxml").title("new xml file").prompt("new xml file!").images(
            ShowCaseImageBundle.INSTANCE.xml(), ShowCaseImageBundle.INSTANCE.xmlDisabled()).enable().show().event(
            new ShowcaseEvent("Create new XML file...")).create();

      simpleCommand2 =
         SimpleCommandBuilder.newCommand("newhtml").title("new html file").prompt("new html file!").images(
            ShowCaseImageBundle.INSTANCE.html(), ShowCaseImageBundle.INSTANCE.htmlDisabled()).enable().show().event(
            new ShowcaseEvent("Create new HTML file...")).create();

      simpleCommand3 =
         SimpleCommandBuilder.newCommand("newgroovy").title("new groovy file").prompt("new groovy file!").images(
            ShowCaseImageBundle.INSTANCE.groovy(), ShowCaseImageBundle.INSTANCE.groovyDisabled()).enable().show()
            .setDelimiterBefore().event(new ShowcaseEvent("Create new GROOVY file...")).create();

      popupMenuCommand1 =
         PopupMenuCommandBuilder.newCommand("popup1").prompt("Left popup menu").images(
            ShowCaseImageBundle.INSTANCE.xml(), ShowCaseImageBundle.INSTANCE.xmlDisabled()).enable().show().addCommand(
            simpleCommand1).addCommand(simpleCommand2).addCommand(simpleCommand3).create();

      popupMenuCommand2 =
         PopupMenuCommandBuilder.newCommand("popup2").prompt("Right popup menu").images(
            ShowCaseImageBundle.INSTANCE.xml(), ShowCaseImageBundle.INSTANCE.xmlDisabled()).enable().show().addCommand(
            simpleCommand1).addCommand(simpleCommand2).addCommand(simpleCommand3).create();
   }

   private void createToolbar()
   {
      toolbar = new GWTToolbarForm(eventBus);
      panel.add(toolbar);

      List<Control> commands = new ArrayList<Control>();
      commands.add(showHidePopupButtonCommand1);
      commands.add(showHidePopupButtonCommand2);
      commands.add(popupMenuCommand1);
      commands.add(popupMenuCommand2);
      commands.add(enableDisablePopupButtonCommand1);

      List<String> toolbarItems = new ArrayList<String>();
      toolbarItems.add(enableDisablePopupButtonCommand1.getId());
      toolbarItems.add(showHidePopupButtonCommand1.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(popupMenuCommand1.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(enableDisablePopupButtonCommand1.getId());

      toolbarItems.add(ToolbarItemType.SPACER);

      toolbarItems.add(ToolbarItemType.DELIMITER);
      toolbarItems.add(popupMenuCommand2.getId());
      toolbarItems.add(showHidePopupButtonCommand2.getId());
      toolbarItems.add(ToolbarItemType.DELIMITER);

      eventBus.fireEvent(new UpdateToolbarEvent(toolbarItems, commands));
   }

   public void onShowcaseEvent(ShowcaseEvent event)
   {
      if (!(event.getObject() instanceof String))
      {
         return;
      }

      String value = (String)event.getObject();
      if ("hide/show left".equals(value))
      {
         if (popupMenuCommand1.isVisible())
         {
            popupMenuCommand1.setVisible(false);
            showHidePopupButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.add(), ShowCaseImageBundle.INSTANCE
               .addDisabled());
            showHidePopupButtonCommand1.setPrompt("Show left popup menu");
         }
         else
         {
            popupMenuCommand1.setVisible(true);
            showHidePopupButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.remove(), ShowCaseImageBundle.INSTANCE
               .removeDisabled());
            showHidePopupButtonCommand1.setPrompt("Hide left popup menu");
         }
         return;
      }

      if ("enable/disable left".equals(value))
      {
         if (popupMenuCommand1.isEnabled())
         {
            popupMenuCommand1.setEnabled(false);
            enableDisablePopupButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.ok(), ShowCaseImageBundle.INSTANCE
               .okDisabled());
            enableDisablePopupButtonCommand1.setPrompt("Enable left popup");
         }
         else
         {
            popupMenuCommand1.setEnabled(true);
            enableDisablePopupButtonCommand1.setImages(ShowCaseImageBundle.INSTANCE.cancel(),
               ShowCaseImageBundle.INSTANCE.cancelDisabled());
            enableDisablePopupButtonCommand1.setPrompt("Disable left popup");
         }

         return;

      }

      Window.alert(value);

   }

}
