/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.smartgwt.dialogs;

import java.util.LinkedList;
import java.util.Queue;

import org.exoplatform.gwtframework.commons.dialogs.callback.BooleanValueReceivedCallback;
import org.exoplatform.gwtframework.commons.dialogs.callback.StringValueReceivedCallback;
import org.exoplatform.gwtframework.ui.client.smartgwt.dialogs.DialogInfo.Type;

import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.ValueCallback;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class DialogManager
{

   private static Queue<DialogInfo> dialogs = new LinkedList<DialogInfo>();

   private static DialogInfo currentDialog;

   public static void showDialog(DialogInfo dialogInfo)
   {
      dialogs.add(dialogInfo);
      checkNextDialog();
   }

   private static void checkNextDialog()
   {
      if (currentDialog != null)
      {
         return;
      }

      if (dialogs.size() == 0)
      {
         return;
      }

      currentDialog = dialogs.poll();

      if (currentDialog.getType() == Type.ASKVALUE)
      {
         askforValue(currentDialog.getTitle(), currentDialog.getMessage(), currentDialog.getDefaultValue(),
            valueCallback);
      }
      else if (currentDialog.getType() == Type.ASK)
      {
         showAskDialog(currentDialog.getTitle(), currentDialog.getMessage(), booleanCallback);
      }
      else if (currentDialog.getType() == Type.WARNING)
      {
         showWarningDialog(currentDialog.getTitle(), currentDialog.getMessage(), booleanCallback);
      }
      else
      {
         showInfoDialog(currentDialog.getTitle(), currentDialog.getMessage(), booleanCallback);
      }

   }

   private static BooleanCallback booleanCallback = new BooleanCallback()
   {
      public void execute(Boolean value)
      {
         if (currentDialog.getCallback() != null)
         {

            if (currentDialog.getCallback() instanceof BooleanValueReceivedCallback)
            {
               BooleanValueReceivedCallback callback = (BooleanValueReceivedCallback)currentDialog.getCallback();
               try
               {
                  callback.execute(value);
               }
               catch (Throwable exc)
               {
                  exc.printStackTrace();
               }
            }

         }
         currentDialog = null;
         checkNextDialog();
      }
   };

   private static ValueCallback valueCallback = new ValueCallback()
   {
      public void execute(String value)
      {
         if (currentDialog.getCallback() != null)
         {

            if (currentDialog.getCallback() instanceof StringValueReceivedCallback)
            {
               StringValueReceivedCallback callback = (StringValueReceivedCallback)currentDialog.getCallback();
               try
               {
                  callback.execute(value);
               }
               catch (Throwable exc)
               {
                  exc.printStackTrace();
               }
            }

         }

         currentDialog = null;
         checkNextDialog();
      }
   };

   private static native void showInfoDialog(String title, String message, BooleanCallback callback) /*-{
        $wnd.isc.say(message,
           function(value)
           {
              var valueJ = value == null ? null : @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(value);
              callback.@com.smartgwt.client.util.BooleanCallback::execute(Ljava/lang/Boolean;)(valueJ);
           },
           {
           title:title,
           showShadow:true
           }
        );
     }-*/;

   public static native void showWarningDialog(String title, String message, BooleanCallback callback) /*-{
      $wnd.isc.warn(message,
         function(value)
         {
            var valueJ = value == null ? null : @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(value);
            if(callback != null) callback.@com.smartgwt.client.util.BooleanCallback::execute(Ljava/lang/Boolean;)(valueJ);
         },
         {
         title:title,
         showShadow:true
         }         
      );
   }-*/;
   
   public static native void showAskDialog(String title, String message, BooleanCallback callback) /*-{
      $wnd.isc.ask(message,
         function(value)
         {
            var valueJ = value == null ? null : @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(value);
             callback.@com.smartgwt.client.util.BooleanCallback::execute(Ljava/lang/Boolean;)(valueJ);
         },
         {
         title:title,
         showShadow:true
         }
      );
   }-*/;   
   
   public static native void askforValue(String title, String message, String defaultValue, ValueCallback callback) /*-{
     $wnd.isc.askForValue(message, 
        function(value)
        {
           if(value === undefined) value = null;
           callback.@com.smartgwt.client.util.ValueCallback::execute(Ljava/lang/String;)(value);
        },
        {
        title:title, 
        width:400,
        defaultValue:defaultValue,
        showShadow:true
        }
     );
  }-*/;

}
