/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import java.util.StringTokenizer;

class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final String classId;
    String stem;

    public int hashCode() {
        return this.classId.hashCode();
    }

    public boolean isUnique() {
        return this.classId.equals(this.stem);
    }

    public boolean matches(ReferenceType referenceType) {
        if (this.classId.startsWith("*")) {
            return referenceType.name().endsWith(this.stem);
        }
        if (this.classId.endsWith("*")) {
            return referenceType.name().startsWith(this.stem);
        }
        return referenceType.name().equals(this.classId);
    }

    public ClassPrepareRequest createPrepareRequest() {
        ClassPrepareRequest classPrepareRequest = Env.vm().eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.classId);
        classPrepareRequest.addCountFilter(1);
        return classPrepareRequest;
    }

    public boolean equals(Object object) {
        if (object instanceof PatternReferenceTypeSpec) {
            PatternReferenceTypeSpec patternReferenceTypeSpec = (PatternReferenceTypeSpec)object;
            return this.classId.equals(patternReferenceTypeSpec.classId);
        }
        return false;
    }

    public String toString() {
        return this.classId;
    }

    PatternReferenceTypeSpec(String string) throws ClassNotFoundException {
        this.classId = string;
        this.stem = string;
        if (string.startsWith("*")) {
            this.stem = this.stem.substring(1);
        } else if (string.endsWith("*")) {
            this.stem = this.stem.substring(0, string.length() - 1);
        }
        this.checkClassName(this.stem);
    }

    private void checkClassName(String string) throws ClassNotFoundException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.isJavaIdentifier(string2)) continue;
            throw new ClassNotFoundException();
        }
    }

    private boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

