/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JabberContentHandler;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageListener;
import com.echomine.jabber.JabberMessageReceiver;
import com.echomine.jabber.JabberProtocol;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.MessageRequestQueue;
import com.echomine.jabber.MsgSessionInit;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketConnector;
import com.echomine.net.TimeableConnection;
import com.echomine.util.Semaphore;

public class JabberConnection
extends TimeableConnection {
    private boolean connected;
    private SocketConnector connector;
    private JabberProtocol handler;
    private ConnectionModel cmodel;
    private Semaphore sem;
    private JabberMessageReceiver receiver;
    private JabberContext context;
    private JabberSession session;
    private MessageRequestQueue queue = new MessageRequestQueue();
    static Class class$com$echomine$net$ConnectionListener;

    public JabberConnection(JabberSession session, JabberMessageReceiver receiver) {
        this.context = session.getContext();
        JabberContentHandler contentHandler = new JabberContentHandler(session, receiver, this.queue);
        this.handler = new JabberProtocol(contentHandler, this.queue);
        this.connector = new SocketConnector(this.handler);
        this.receiver = receiver;
        this.sem = new Semaphore(0L);
        this.connector.addConnectionListener(new JabberConnectionListener(this));
    }

    public void disconnect() {
        this.handler.shutdown();
    }

    public synchronized void connect(ConnectionModel cmodel) throws ConnectionFailedException {
        if (this.connected) {
            return;
        }
        this.cmodel = cmodel;
        this.queue.start();
        this.connector.aconnect(cmodel);
        try {
            this.sem.acquire();
            if (!this.connected) {
                throw new ConnectionFailedException("Connection Failed");
            }
        }
        catch (InterruptedException ex) {
            this.disconnect();
            throw new ConnectionFailedException("Timeout during connection");
        }
    }

    public void send(JabberMessage msg) throws SendMessageFailedException {
        if (!this.connected) {
            throw new SendMessageFailedException("Send Failure: not connected to server");
        }
        try {
            JabberMessage jabberMessage = msg;
            synchronized (jabberMessage) {
                try {
                    this.handler.send(msg);
                    if (msg.isSynchronized()) {
                        msg.wait(msg.getTimeout());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }
        catch (InterruptedException ex) {
            throw new SendMessageFailedException("Send Failure: interrupted while waiting for reply");
        }
    }

    public void sendLater(Runnable sendThread) {
        Thread thread = new Thread(sendThread, "Send Message Thread");
        thread.start();
    }

    public void addConnectionListener(ConnectionListener l) {
        this.listenerList.add(class$com$echomine$net$ConnectionListener == null ? (class$com$echomine$net$ConnectionListener = JabberConnection.class$("com.echomine.net.ConnectionListener")) : class$com$echomine$net$ConnectionListener, l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.listenerList.remove(class$com$echomine$net$ConnectionListener == null ? (class$com$echomine$net$ConnectionListener = JabberConnection.class$("com.echomine.net.ConnectionListener")) : class$com$echomine$net$ConnectionListener, l);
    }

    public ConnectionModel getConnectionModel() {
        return this.cmodel;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void addMessageListener(JabberMessageListener l) {
        this.receiver.addMessageListener(l);
    }

    public void removeMessageListener(JabberMessageListener l) {
        this.receiver.removeMessageListener(l);
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }

    static void access$0(JabberConnection obj$, ConnectionEvent event) throws ConnectionVetoException {
        obj$.fireConnectionStartingWithoutVeto(event);
    }

    static boolean access$1(JabberConnection obj$, boolean val$) {
        obj$.connected = val$;
        return obj$.connected;
    }

    static void access$2(JabberConnection obj$, ConnectionEvent event) {
        obj$.fireConnectionEstablished(event);
    }

    static boolean access$3(JabberConnection obj$) {
        return obj$.connected;
    }

    static Semaphore access$4(JabberConnection obj$) {
        return obj$.sem;
    }

    static void access$5(JabberConnection obj$, ConnectionEvent event) {
        obj$.fireConnectionClosed(event);
    }

    static JabberContext access$7(JabberConnection obj$) {
        return obj$.context;
    }

    class JabberConnectionListener
    implements ConnectionListener {
        private final JabberConnection this$JabberConnection;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            JabberConnection.access$0(this.this$JabberConnection, e);
        }

        public void connectionEstablished(ConnectionEvent e) {
            JabberConnection.access$1(this.this$JabberConnection, true);
            _1 run = new _1(this);
            this.this$JabberConnection.sendLater(run);
            JabberConnection.access$2(this.this$JabberConnection, e);
        }

        public void connectionClosed(ConnectionEvent e) {
            if (!JabberConnection.access$3(this.this$JabberConnection)) {
                JabberConnection.access$4(this.this$JabberConnection).release();
            }
            JabberConnection.access$1(this.this$JabberConnection, false);
            JabberConnection.access$5(this.this$JabberConnection, e);
        }

        JabberConnectionListener(JabberConnection enclosing$instance) {
            this.this$JabberConnection = enclosing$instance;
        }

        static JabberConnection access$6(JabberConnectionListener obj$) {
            return obj$.this$JabberConnection;
        }

        class _1
        implements Runnable {
            private final JabberConnectionListener this$JabberConnectionListener;

            public void run() {
                MsgSessionInit init = new MsgSessionInit(JabberConnection.access$7(JabberConnectionListener.access$6(this.this$JabberConnectionListener)).getServerName());
                init.setMessageReplyHandler(JabberConnection.access$7(JabberConnectionListener.access$6(this.this$JabberConnectionListener)));
                try {
                    JabberConnectionListener.access$6(this.this$JabberConnectionListener).send(init);
                    JabberConnection.access$4(JabberConnectionListener.access$6(this.this$JabberConnectionListener)).release();
                }
                catch (SendMessageFailedException sendMessageFailedException) {
                    // empty catch block
                }
            }

            _1(JabberConnectionListener enclosing$instance) {
                this.this$JabberConnectionListener = enclosing$instance;
            }
        }
    }
}

