/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.DefaultMessageReceiver;
import com.echomine.jabber.JabberChatService;
import com.echomine.jabber.JabberClientService;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageListener;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.JabberMessageReceiver;
import com.echomine.jabber.JabberPresenceService;
import com.echomine.jabber.JabberRosterService;
import com.echomine.jabber.JabberServerService;
import com.echomine.jabber.JabberUserService;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionModel;
import java.net.UnknownHostException;

public class JabberSession {
    private JabberContext context;
    private JabberMessageReceiver receiver;
    private JabberConnection connection;
    private JabberMessageParser msgParser;
    private JabberUserService userService;
    private JabberPresenceService presenceService;
    private JabberRosterService rosterService;
    private JabberChatService chatService;
    private JabberServerService serverService;
    private JabberClientService clientService;

    public JabberSession(JabberContext context, JabberMessageParser parser) {
        this.context = context;
        this.receiver = new DefaultMessageReceiver();
        this.msgParser = parser;
        this.connection = new JabberConnection(this, this.receiver);
        this.userService = new JabberUserService(this.connection, context);
        this.presenceService = new JabberPresenceService(this.connection, context);
        this.rosterService = new JabberRosterService(this.connection, context);
        this.chatService = new JabberChatService(this.connection, context);
        this.serverService = new JabberServerService(this.connection, context);
        this.clientService = new JabberClientService(this.connection, context);
    }

    public void connect(String hostname, int port) throws ConnectionFailedException, UnknownHostException {
        this.connect(new ConnectionModel(hostname, port));
    }

    public void connect(ConnectionModel cmodel) throws ConnectionFailedException {
        this.connection.connect(cmodel);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void sendMessage(JabberMessage msg) throws SendMessageFailedException {
        this.connection.send(msg);
    }

    public JabberContext getContext() {
        return this.context;
    }

    public JabberConnection getConnection() {
        return this.connection;
    }

    public JabberMessageParser getMessageParser() {
        return this.msgParser;
    }

    public JabberRosterService getRosterService() {
        return this.rosterService;
    }

    public JabberChatService getChatService() {
        return this.chatService;
    }

    public JabberPresenceService getPresenceService() {
        return this.presenceService;
    }

    public JabberUserService getUserService() {
        return this.userService;
    }

    public JabberServerService getServerService() {
        return this.serverService;
    }

    public void addMessageListener(JabberMessageListener l) {
        this.connection.addMessageListener(l);
    }

    public void removeMessageListener(JabberMessageListener l) {
        this.connection.removeMessageListener(l);
    }

    public JabberClientService getClientService() {
        return this.clientService;
    }
}

