/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net.junit;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.PerpetualSocketAcceptor;
import com.echomine.net.SocketHandler;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.Socket;
import junit.framework.TestCase;

public class PerpetualSocketAcceptorTest
extends TestCase {
    ConnectionModel model;
    PerpetualSocketAcceptor acceptor;
    SocketHandler handler;

    public PerpetualSocketAcceptorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.model = new ConnectionModel("127.0.0.1", 7000);
        this.acceptor = new PerpetualSocketAcceptor(this.model);
        this.handler = new _1(this);
    }

    protected void tearDown() throws Exception {
        this.acceptor.close();
    }

    public void testSocketAcceptorNormalAsync() throws Exception {
        this.acceptor.aaccept(this.handler);
        int numPasses = 0;
        int i = 0;
        while (i < 3) {
            Socket socket = new Socket("127.0.0.1", 7000);
            byte[] data = new byte[10];
            int bytesRead = socket.getInputStream().read(data);
            if (bytesRead == -1) {
                PerpetualSocketAcceptorTest.fail((String)("Unable to read any bytes at try #" + numPasses));
            }
            String result = new String(data, 0, bytesRead);
            PerpetualSocketAcceptorTest.assertEquals((String)("Failed at try #" + numPasses), (Object)"Success", (Object)result);
            IOUtil.closeSocket(socket);
            ++i;
            ++numPasses;
        }
        PerpetualSocketAcceptorTest.assertTrue((String)("Total Passes: " + numPasses), (numPasses == 3 ? 1 : 0) != 0);
    }

    public void testSocketAcceptorNormalSync() throws Exception {
        _2 thread = new _2(this);
        thread.start();
        int numPasses = 0;
        int i = 0;
        while (i < 3) {
            Socket socket = new Socket("127.0.0.1", 7000);
            byte[] data = new byte[10];
            int bytesRead = socket.getInputStream().read(data);
            if (bytesRead == -1) {
                PerpetualSocketAcceptorTest.fail((String)("Unable to read any bytes at try #" + numPasses));
            }
            String result = new String(data, 0, bytesRead);
            PerpetualSocketAcceptorTest.assertEquals((String)("Failed at try #" + numPasses), (Object)"Success", (Object)result);
            IOUtil.closeSocket(socket);
            ++i;
            ++numPasses;
        }
        PerpetualSocketAcceptorTest.assertTrue((String)("Total Passes: " + numPasses), (numPasses == 3 ? 1 : 0) != 0);
    }

    public void testAcceptorConnectionListener() throws Exception {
        AcceptorConnectionListener l = new AcceptorConnectionListener(this);
        this.acceptor.aaccept(this.handler);
        this.acceptor.addConnectionListener(l);
        Socket socket = new Socket("127.0.0.1", 7000);
        Thread.currentThread();
        Thread.sleep(500L);
        IOUtil.closeSocket(socket);
        PerpetualSocketAcceptorTest.assertTrue((l.starting ? 1 : 0) != 0);
        PerpetualSocketAcceptorTest.assertTrue((l.established ? 1 : 0) != 0);
        PerpetualSocketAcceptorTest.assertTrue((l.closed ? 1 : 0) != 0);
    }

    public void testAcceptorVetoedConnectionListener() throws Exception {
        VetoedConnectionListener l = new VetoedConnectionListener(this);
        this.acceptor.aaccept(this.handler);
        this.acceptor.addConnectionListener(l);
        Socket socket = new Socket("127.0.0.1", 7000);
        Thread.currentThread();
        Thread.sleep(500L);
        IOUtil.closeSocket(socket);
        PerpetualSocketAcceptorTest.assertTrue((l.starting ? 1 : 0) != 0);
        PerpetualSocketAcceptorTest.assertTrue((!l.established ? 1 : 0) != 0);
        PerpetualSocketAcceptorTest.assertTrue((l.closed ? 1 : 0) != 0);
    }

    class _1
    implements SocketHandler {
        private final PerpetualSocketAcceptorTest this$PerpetualSocketAcceptorTest;

        public void handle(Socket socket) throws IOException {
            socket.getOutputStream().write("Success".getBytes());
        }

        public void shutdown() {
        }

        public void start() {
        }

        _1(PerpetualSocketAcceptorTest enclosing$instance) {
            this.this$PerpetualSocketAcceptorTest = enclosing$instance;
        }
    }

    class _2
    extends Thread {
        private final PerpetualSocketAcceptorTest this$PerpetualSocketAcceptorTest;

        public void run() {
            this.this$PerpetualSocketAcceptorTest.acceptor.accept(this.this$PerpetualSocketAcceptorTest.handler);
        }

        _2(PerpetualSocketAcceptorTest enclosing$instance) {
            this.this$PerpetualSocketAcceptorTest = enclosing$instance;
        }
    }

    class AcceptorConnectionListener
    implements ConnectionListener {
        private final PerpetualSocketAcceptorTest this$PerpetualSocketAcceptorTest;
        boolean starting;
        boolean established;
        boolean closed;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            this.starting = true;
        }

        public void connectionEstablished(ConnectionEvent e) {
            this.established = true;
        }

        public void connectionClosed(ConnectionEvent e) {
            this.closed = true;
        }

        AcceptorConnectionListener(PerpetualSocketAcceptorTest enclosing$instance) {
            this.this$PerpetualSocketAcceptorTest = enclosing$instance;
            this.starting = false;
            this.established = false;
            this.closed = false;
        }
    }

    class VetoedConnectionListener
    extends AcceptorConnectionListener {
        private final PerpetualSocketAcceptorTest this$PerpetualSocketAcceptorTest;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            super.connectionStarting(e);
            throw new ConnectionVetoException("Vetoed");
        }

        VetoedConnectionListener(PerpetualSocketAcceptorTest enclosing$instance) {
            super(enclosing$instance);
            this.this$PerpetualSocketAcceptorTest = enclosing$instance;
        }
    }
}

