/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */

package org.exoplatform.gwtframework.commons.dialogs;

import org.exoplatform.gwtframework.commons.dialogs.callback.BooleanValueReceivedCallback;
import org.exoplatform.gwtframework.commons.dialogs.callback.StringValueReceivedCallback;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public abstract class Dialogs
{

   private static Dialogs instance;

   protected Dialogs()
   {
      instance = this;
   }

   public static Dialogs getInstance()
   {
      return instance;
   }

   /*
    * INFO
    */

   public abstract void showInfo(String message);

   public abstract void showInfo(String title, String message);

   public abstract void showInfo(String title, String message, BooleanValueReceivedCallback callback);

   /*
    * WARNING
    */

   public abstract void showError(String message);

   public abstract void showError(String title, String message);

   public abstract void showError(String title, String message, BooleanValueReceivedCallback callback);

   /*
    * BOOLEAN ASKING
    */

   public abstract void ask(String title, String message, BooleanValueReceivedCallback callback);

   /*
    * VALUE ASKING
    */

   public abstract void askForValue(String title, String message, String defaultValue,
      StringValueReceivedCallback callback);

}
