/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.editor.fckeditor;

import java.util.List;

import org.exoplatform.gwtframework.commons.dialogs.Dialogs;
import org.exoplatform.gwtframework.commons.rest.MimeType;
import org.exoplatform.gwtframework.editor.api.EditorConfiguration;
import org.exoplatform.gwtframework.editor.api.GWTTextEditor;
import org.exoplatform.gwtframework.editor.api.Token;
import org.exoplatform.gwtframework.editor.event.EditorActivityEvent;
import org.exoplatform.gwtframework.editor.event.EditorContentChangedEvent;
import org.exoplatform.gwtframework.editor.event.EditorInitializedEvent;
import org.exoplatform.gwtframework.editor.event.EditorSaveContentEvent;
import org.exoplatform.gwtframework.editor.fckeditor.FCKEditorConfiguration.StartupMode;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Label;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:dmitry.ndp@gmail.com">Dmitry Nochevnov</a>
 * @version $
 */

public class FCKEditor extends GWTTextEditor
{

   private Label label;

   private JavaScriptObject editorObject;

   private int onContentChangeListenerId;

   private int onEditorResizeListenerId;

   private String prefix = "";

   private String suffix = "";   
   
   public FCKEditor(HandlerManager eventBus, EditorConfiguration configuration)
   {
      super(eventBus, configuration);

      label = new Label();
      DOM.setElementAttribute(label.getElement(), "id", getEditorId());
      DOM.setElementAttribute(label.getElement(), "style", "overflow: auto; width: 100%; height: 100%;"); // to show scrollbars and to display on the full tab         
      editorPanel().add(label);

      // switch on CKEditor fullPage mode only for html-files
      if (configuration.getMimeType().equals(MimeType.TEXT_HTML))
      {
         FCKEditorConfiguration.setFullPage(true);
      }
   }

   protected void onLoad()
   {
      super.onLoad();
      editorObject =
         initFCKEditor(getEditorId(),
            FCKEditorConfiguration.BASE_PATH,
            FCKEditorConfiguration.TOOLBAR.toString(), // aditional default configuration can be found in config.js
            FCKEditorConfiguration.THEME.toString(), 
            FCKEditorConfiguration.SKIN.toString(),
            FCKEditorConfiguration.LANGUAGE.toString(), 
            FCKEditorConfiguration.CONTINUOUS_SCANNING,
            FCKEditorConfiguration.isFullPage());       
   }

   private native JavaScriptObject initFCKEditor(String id, String basePath, String toolbar,
      String theme, String skin, String language, int continuousScanning, boolean fullPage) /*-{     
      var instance = this;
      if (toolbar !== undefined) {
         $wnd.CKEDITOR.config.toolbar = toolbar;
      }       

      if (theme !== undefined) {
         $wnd.CKEDITOR.config.theme = theme;
      }       
      
      if (language !== undefined) {
         $wnd.CKEDITOR.config.language = language;
      }              
      
      if (basePath !== undefined) {
         $wnd.CKEDITOR.basePath = basePath;
         $wnd.CKEDITOR.config.contentsCss = basePath + "contents.css";   // reflects the CSS used in the final pages where the contents are to be used.
         $wnd.CKEDITOR.plugins.basePath = basePath + "plugins/";     // set base path to the plugins folder
         $wnd.CKEDITOR.config.templates_files[0] = basePath + "plugins/templates/templates/default.js";   // set default template path
         $wnd.CKEDITOR.config.smiley_path = basePath + "plugins/smiley/images/";   // The base path used to build the URL for the smiley images.
      }       
      
      if (skin !== undefined) {
         $wnd.CKEDITOR.config.skin = skin + ',' + basePath + 'skins/' + skin + '/';
      }
      
      if (fullPage !== undefined) {
         $wnd.CKEDITOR.config.fullPage = fullPage;
      }    
      
      // create editor instance      
      var editor = $wnd.CKEDITOR.appendTo(id, $wnd.CKEDITOR.config);  
      
      // add listeners
      if (editor !== null) {                         
         // init editor content variable
         editor.exoSavedContent = ""; 
         
         // set onContentChangeListener
         editor.exoChangeFunction = function(){
           // test if editor iframe is existed 
           if (instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::getLabelOffsetHeight()() === 0) {
              instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onUnload()();   // clear all listeners
              return;
           }

           // check if content was changed
           if (editor.checkDirty()) {            
              editor.resetDirty();
              if ( editor.getData() != editor.exoSavedContent ) {
                 instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onContentChanged()();
              }               
           }
         }
         instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onContentChangeListenerId = $wnd.setInterval(editor.exoChangeFunction, continuousScanning);
         
         // add Hot Key Listener
         instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::setHotKeysClickListener(Lcom/google/gwt/core/client/JavaScriptObject;)(editor);
//         var Ctrl_s_keycode = $wnd.CKEDITOR.CTRL + 115;
//         var Ctrl_S_keycode = $wnd.CKEDITOR.CTRL + 83;          
//         editor.exoSaveFunction = function(e) {
//            // test if was pressed "Ctrl + S" or "Ctrl + s"
//            if (e.data.keyCode == Ctrl_s_keycode || e.data.keyCode == Ctrl_S_keycode) {
//              instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onSaveContent()();  // call onSaveContent() listener                
//              return false;  // this disables default action (submitting the form)
//            }
//         }
//         editor.on('key', editor.exoSaveFunction);
         
         // add onCursorActitvity listener
         editor.exoCursorActivity = function() {
           instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onCursorActivity()();               
         }
         editor.on('key', editor.exoCursorActivity);
                   
         // set init callback
         editor.exoInitCallback = function() {
           instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onInitialized()(); 
           instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onEditorResizeListenerId = $wnd.setInterval(function() {
             instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onResize()();
           }, 200);
         }
         
         editor.on('instanceReady', editor.exoInitCallback);
      }
      
      editor.exoNativeAlert = $wnd.alert;
      editor.exoNativeConfirm = $wnd.confirm;      
      instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::overrideNativeAlertAndConfirm()();
      
      return editor;
  }-*/;
      
   private void onContentChanged()
   {
      eventBus.fireEvent(new EditorContentChangedEvent(getEditorId()));
   }

   private void onSaveContent()
   {
      eventBus.fireEvent(new EditorSaveContentEvent(getEditorId()));
   }

   private void onCursorActivity()
   {
      eventBus.fireEvent(new EditorActivityEvent(getEditorId()));
   }

   private void onInitialized()
   {
      eventBus.fireEvent(new EditorInitializedEvent(getEditorId()));
   }

   public native String getText()/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         editor.exoSavedContent = editor.getData();
         return this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::prefix +
                editor.exoSavedContent +
                this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::suffix;
      }
   }-*/;

   public String parseText(String text)
   {
      if (this.configuration.getMimeType().equals(MimeType.GOOGLE_GADGET))
      {
         this.prefix = GoogleGadgetParser.getPrefix(text);
         String content = GoogleGadgetParser.getContentSection(text);
         this.suffix = GoogleGadgetParser.getSuffix(text);
         return content;
      }
      else
      {
         return text;
      }
   };

   public void setText(String text)
   {
      // extract CDATA section from google gadget
      if (configuration.getMimeType().equals(MimeType.GOOGLE_GADGET))
      {
         // test if it is possible to localize CDATA section
         if (GoogleGadgetParser.hasContentSection(text))
         {
            text = this.parseText(text);
         }
         else
         {
            showErrorDialog("Google Gadget parsing error", "It is impossibe to localize Content section of gadget, which must be placed between '&lt;Content type=\"html\"&gt;&lt;![CDATA[' and ']]&gt;&lt;/Content&gt;' tags! So you will see all gadget content in 'source' mode.");
            this.setEditorMode(StartupMode.SOURCE.toString());
            // generate content section absence gadget error event 
         }
      }

      this.setData(text);
   }
   
   private native void setEditorMode(String mode)/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         editor.setMode(mode);
      }
   }-*/;

   private native void setData(String data)/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         $wnd.setTimeout(function(){
            editor.resetDirty();  // reset ckeditor content changed indicator
            editor.setData(data);           
            editor.exoSavedContent = data;
            editor.focus();         
         }, 200);
      }
   }-*/;

   public native void undo()/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         editor.execCommand("undo");
      }
   }-*/;

   public native void redo()/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         editor.execCommand("redo");
      }
   }-*/;

   @Deprecated
   public native void formatSource()/*-{
   }-*/;

   public native void replaceText(String text)/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         // TODO
      }
   }-*/;

   @Deprecated
   public native void setLineNumbers(boolean showLineNumbers)/*-{
      }-*/;

   public native void setFocus()/*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (editor != null) {
         $wnd.setTimeout(function(a, b){
            editor.focus();         
         }, 200);
      }
   }-*/;

   public native boolean hasRedoChanges()/*-{
      return true;
   }-*/;

   public native boolean hasUndoChanges()/*-{
      return true;
   }-*/;

   public boolean canFormatSource()
   {
      return false;
   }

   public boolean canSetLineNumbers()
   {
      return false;
   }

   /*
    * remove listeners and restore functions
    */
   protected void onUnload()
   {
      removeEditorListeners();
      removeOnContentChangeListener();
      removeOnEditorResizeListener();
      restoreNativeAlertAndConfirm();
   }

   private native void restoreNativeAlertAndConfirm() /*-{
      var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
      if (typeof editor.exoNativeAlert === "function"
          && typeof editor.exoNativeConfirm === "function"
         )
      {
         $wnd.alert = editor.exoNativeAlert;
         $wnd.confirm = editor.exoNativeConfirm;
      }            
   }-*/;

   private native void removeOnContentChangeListener() /*-{
     var onContentChangeListenerId = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onContentChangeListenerId;
     if (onContentChangeListenerId !== null) {
        $wnd.clearInterval(onContentChangeListenerId);      
     }
   }-*/;

   private native void removeOnEditorResizeListener() /*-{
     var onEditorResizeListenerId = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onEditorResizeListenerId;
     if (onEditorResizeListenerId !== null) {
        $wnd.clearInterval(onEditorResizeListenerId);      
     }
   }-*/;

   /*
    * onResize Listener to set editor height into the 100%
    */
   protected native void onResize() /*-{
     var labelOffsetHeight = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::getLabelOffsetHeight()();
     // test if editor iframe is existed
     if (labelOffsetHeight === 0) {
        this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onUnload()();   // clear all listeners
        return;
     }
     
     // check if editor was resized
     var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;      
     if (editor !== null) {
       if (!editor.labelOffsetHeight || (editor.labelOffsetHeight !== labelOffsetHeight)) {
          editor.labelOffsetHeight = labelOffsetHeight;
          editor.resize("100%", labelOffsetHeight);
       }
     }
   }-*/;

   private native void removeEditorListeners() /*-{
     var editor = this.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::editorObject;
     if (editor !== null) {
       // remove 'instanceReady' listener
       if (editor.hasListeners('instanceReady')) {
         editor.removeListener('instanceReady', editor.exoInitCallback)                
       }        
       
       // remove 'key' listeners       
       if (editor.hasListeners('key')) {
         editor.removeListener('key', editor.exoCursorActivity);          
       }
       
       if (editor.hasListeners('key')) {
         editor.removeListener('key', editor.exoHotKeysClickListener);          
       }        
     }   
   }-*/;

   @Deprecated
   public boolean isReadOnly()
   {
      // TODO http://cksource.com/forums/viewtopic.php?f=5&t=69
      return false;
   }

   @Deprecated
   public void setReadOnly(boolean readOnly)
   {
      // TODO http://cksource.com/forums/viewtopic.php?f=5&t=69

   }

   public int getLabelOffsetHeight()
   {
      return editorPanel().getOffsetHeight();
   }
   
   private static void showErrorDialog(String title, String message) 
   {
      Dialogs.getInstance().showError(title, message);
   }

   /**
    * replace window.alert() function on org.exoplatform.gwtframework.ui.client.dialogs.Dialogs.showError() and hide window.confirm() function
    * */
   private native void overrideNativeAlertAndConfirm() /*-{ 
      if ($wnd.isc) {    // test if there is smartgwt library
         (function(){
            var proxied = $wnd.alert;
            $wnd.alert = function(message){
               // test if this is a in context of ckeditor
               if (typeof $wnd.CKEDITOR !== "undefined" ) {
                  @org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::showErrorDialog(Ljava/lang/String;Ljava/lang/String;)("WYSIWYG Editor Error",message);
               } else {
                  return proxied(message);
               }
            };
         })(this);
      }
     
      (function(){
         var proxied = $wnd.confirm;

         $wnd.confirm = function(message) {
            // test if this is a ckeditor
            if (typeof $wnd.CKEDITOR !== "undefined" ) {
               return true;
            } else {
               return proxied(message);
            }
         };
      })();

   }-*/;

   public boolean canDeleteCurrentLine()
   {
      return false;
   }

   public boolean canFindAndReplace()
   {
      return false;
   }

   public boolean canGoToLine()
   {
      return false;
   }
   
   public void deleteCurrentLine() {}

   public void goToLine(int lineNumber) {}

   public int getCursorCol()
   {
      return 0;
   }

   public int getCursorRow()
   {
      return 0;
   }

   public boolean findAndSelect(String find, boolean caseSensitive)
   {
      return false;
   }

   public void replaceFoundedText(String find, String replace, boolean caseSensitive) {}

   public void setHotKeyList(List<String> hotKeyList)
   {
      configuration.setHotKeyList(hotKeyList);
   }
   
   private HandlerManager getEventBus() 
   {
      return eventBus;
   }

   private EditorConfiguration getConfiguration() 
   {
      return configuration;
   }
      
   /**
    * Set listeners of hot keys clicking 
    */
   private native void setHotKeysClickListener(JavaScriptObject editor) /*-{
      var instance = this;
      if (editor) {
         editor.exoHotKeysClickListener = function(e) {   
            // filter key pressed without ctrl 
            if (e.data.keyCode < $wnd.CKEDITOR.CTRL) return;
            
            // see doc at http://docs.cksource.com/ckeditor_api/symbols/CKEDITOR.html#event:key
            var keyPressed = "";
            if (e.data.keyCode < $wnd.CKEDITOR.ALT) {
               // after pressing Ctrl+something
               keyPressed += "Ctrl+" + String(e.data.keyCode - $wnd.CKEDITOR.CTRL);
            } else {
               // after pressing Alt+something
               keyPressed += "Alt+" + String(e.data.keyCode - $wnd.CKEDITOR.ALT);
            }              
            
            // find similar key ammong the hotKeyList
            var configuration = instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::getConfiguration()();
            var hotKeyList = configuration.@org.exoplatform.gwtframework.editor.api.EditorConfiguration::getHotKeyList()();                  

            // listen Ctrl+S key pressing if hotKeyList is null
            if (hotKeyList === null) { 
               if (keyPressed == "Ctrl+" + "S".charCodeAt(0)) {
                  instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::onSaveContent()();
                  return false;                        
               } else {
                  return;
               }                      
            }

            for (var i = 0; i < hotKeyList.@java.util.List::size()(); i++) {
              var currentHotKey = hotKeyList.@java.util.List::get(I)(i); 
              if (currentHotKey == keyPressed) {
                // fire EditorHotKeyCalledEvent
                var editorHotKeyCalledEventInstance = @org.exoplatform.gwtframework.editor.event.EditorHotKeyCalledEvent::new(Ljava/lang/String;)(
                  currentHotKey
                );
                var eventBus = instance.@org.exoplatform.gwtframework.editor.fckeditor.FCKEditor::getEventBus()();
                eventBus.@com.google.gwt.event.shared.HandlerManager::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(editorHotKeyCalledEventInstance);

                return false;                
              }
            }
         }
         editor.on('key', editor.exoHotKeysClickListener);
      }
   }-*/;


   public boolean canCreateTokenList()
   {
      return false;
   }
   
   public List<Token> getTokenList()
   {
      return null;
   }
   
}