/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.lock;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbsolutePanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class LockLayer extends AbsolutePanel
{

   private static interface Style
   {

      static final String LOCK_LAYER = "exo-lockLayer";

   }

   private LockLayerClickedHandler lockLayerClickedHandler;

   public LockLayer(int width, int height, LockLayerClickedHandler lockLayerClickedHandler)
   {
      this.lockLayerClickedHandler = lockLayerClickedHandler;

      //RootPanel.get().add(lockLayer, 0, 0);
      setWidth("" + width + "px");
      setHeight("" + height + "px");
      //DOM.setElementAttribute(panel.getElement(), "id", "menu-lock-layer-id");
      DOM.setStyleAttribute(getElement(), "zIndex", "" + (Integer.MAX_VALUE));

      BlockMouseEventsPanel blockMouseEventsPanel = new BlockMouseEventsPanel();
      blockMouseEventsPanel.setStyleName(Style.LOCK_LAYER);
      blockMouseEventsPanel.setWidth("" + width + "px");
      blockMouseEventsPanel.setHeight("" + height + "px");
      add(blockMouseEventsPanel, 0, 0);
   }

   /**
    *  Lock Layer uses for locking of screen. Uses for hiding popups.
    */
   private class BlockMouseEventsPanel extends AbsolutePanel
   {

      public BlockMouseEventsPanel()
      {
         sinkEvents(Event.ONMOUSEDOWN);
      }

      @Override
      public void onBrowserEvent(Event event)
      {
         switch (DOM.eventGetType(event))
         {
            case Event.ONMOUSEDOWN :
               if (lockLayerClickedHandler != null)
               {
                  lockLayerClickedHandler.onLockLayerClicked();
               }
               break;
         }
      }

   }

}
