/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.toolbar.component;

import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;
import org.exoplatform.gwtframework.ui.client.component.command.SimpleControlStateListener;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbar;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarButton extends Composite implements ToolbarControl, SimpleControlStateListener
{

   public static interface Style
   {

      public final static String BUTTON_PANEL_LEFT = "exo-toolbar16ButtonPanel_Left";

      public final static String BUTTON_PANEL_RIGHT = "exo-toolbar16ButtonPanel_Right";

      public final static String BUTTON_PANEL_LEFT_HIDDEN = "exo-toolbar16ButtonPanel_LeftHidden";

      public final static String BUTTON_PANEL_RIGHT_HIDDEN = "exo-toolbar16ButtonPanel_RightHidden";

      public final static String BUTTON = "exo-toolbar16Button";

      public final static String BUTTON_OVER = "exo-toolbar16ButtonOver";

      public final static String BUTTON_DOWN = "exo-toolbar16ButtonDown";

      public final static String BUTTON_SELECTED = "exo-toolbar16Button-selected";

      public final static String BUTTON_SELECTED_OVER = "exo-toolbar16Button-selectedOver";

      public final static String BUTTON_SELECTED_DOWN = "exo-toolbar16Button-selectedDown";

      public final static String BUTTON_ICON = "exo-toolbar16Icon";

   }

   private final static String DISABLED_SUFFIX = "_Disabled";

   private HandlerManager eventBus;

   private SimpleControl command;

   private SimplePanel simplePanel;

   private String iconNormal;

   private String iconDisabled;

   private ButtonPanel buttonPanel;

   private boolean rightDocking;

   private boolean pressedOnce = false;

   private GWTToolbar toolbar;

   private boolean overed = false;

   public ToolbarButton(HandlerManager eventBus, SimpleControl command, boolean rightDocking, GWTToolbar toolbar)
   {
      this.eventBus = eventBus;
      this.command = command;
      this.rightDocking = rightDocking;
      this.toolbar = toolbar;

      setIcon(command.getIcon());

      simplePanel = new SimplePanel();
      initWidget(simplePanel);
      updateButtonVisibility();
      simplePanel.setTitle(command.getPrompt());

      createButtonPanel();
      
      DOM.setElementAttribute(buttonPanel.getElement(), "elementenabled", String.valueOf(command.isEnabled()));

      command.getStateListeners().add(this);
   }

   private void setIcon(String icon)
   {
      if (command.getIcon() == null)
      {
         return;
      }

      iconNormal = icon;
      iconDisabled = iconNormal.substring(0, iconNormal.lastIndexOf("."));
      iconDisabled += DISABLED_SUFFIX;
      iconDisabled += iconNormal.substring(iconNormal.lastIndexOf("."));
   }

   @Override
   protected void onDetach()
   {
      super.onDetach();
   }

   public SimpleControl getCommand()
   {
      return command;
   }

   private Image getImage()
   {
      Image image = null;

      if (command.isEnabled())
      {
         if (command.getNormalImage() != null)
         {
            image = new Image(command.getNormalImage());
         }
         else
         {
            image = new Image(iconNormal);
         }
      }
      else
      {
         if (command.getDisabledImage() != null)
         {
            image = new Image(command.getDisabledImage());
         }
         else
         {
            image = new Image(iconDisabled);
         }
      }

      image.setStyleName(Style.BUTTON_ICON);
      return image;
   }

   private void createButtonPanel()
   {
      buttonPanel = new ButtonPanel();
      buttonPanel.setStyleName(Style.BUTTON);

      Image image = getImage();
      buttonPanel.add(image);
      simplePanel.add(buttonPanel);
   }

   protected void onMouseOver()
   {
      overed = true;

      if (command.isSelected())
      {
         buttonPanel.setStyleName(Style.BUTTON_SELECTED_OVER);
      }
      else
      {
         buttonPanel.setStyleName(Style.BUTTON_OVER);
      }
      pressedOnce = false;
   }

   protected void onMouseOut()
   {
      overed = false;

      if (command.isSelected())
      {
         buttonPanel.setStyleName(Style.BUTTON_SELECTED);
      }
      else
      {
         buttonPanel.setStyleName(Style.BUTTON);
      }
   }

   protected void onMouseDown()
   {
      if (command.canBeSelected())
      {
         if (command.isSelected())
         {
            command.setSelected(false);
            buttonPanel.setStyleName(Style.BUTTON_DOWN);
         }
         else
         {
            command.setSelected(true);
            buttonPanel.setStyleName(Style.BUTTON_SELECTED_DOWN);
         }

      }
      else
      {
         buttonPanel.setStyleName(Style.BUTTON_DOWN);
      }

      pressedOnce = true;
   }

   protected void onMouseUp()
   {
      if (command.isSelected())
      {
         buttonPanel.setStyleName(Style.BUTTON_SELECTED_OVER);
      }
      else
      {
         buttonPanel.setStyleName(Style.BUTTON_OVER);
      }

      if (pressedOnce)
      {
         pressedOnce = false;

         if (command.getEvent() != null)
         {
            eventBus.fireEvent(command.getEvent());
         }
      }
   }

   public void updateControlEnabling(boolean enabled)
   {
      Image image = getImage();
      buttonPanel.clear();
      buttonPanel.add(image);
      DOM.setElementAttribute(buttonPanel.getElement(), "elementenabled", String.valueOf(enabled));
      
      if (command.isSelected())
      {
         buttonPanel.setStyleName(Style.BUTTON_SELECTED);
      }
      else
      {
         buttonPanel.setStyleName(Style.BUTTON);
      }

   }

   protected void updateButtonVisibility()
   {
      if (command.isVisible())
      {
         simplePanel.setStyleName(rightDocking ? Style.BUTTON_PANEL_RIGHT : Style.BUTTON_PANEL_LEFT);
      }
      else
      {
         simplePanel.setStyleName(rightDocking ? Style.BUTTON_PANEL_RIGHT_HIDDEN : Style.BUTTON_PANEL_LEFT_HIDDEN);
      }
   }

   public void updateControlVisibility(boolean visible)
   {
      updateButtonVisibility();
      toolbar.checkDelimiters();
   };

   public void updateCommandSelectedState(boolean selected)
   {
   }

   public boolean isControlVisible()
   {
      return command.isVisible();
   }

   private class ButtonPanel extends SimplePanel
   {

      public ButtonPanel()
      {
         sinkEvents(Event.ONMOUSEOVER | Event.ONMOUSEOUT | Event.ONMOUSEDOWN | Event.ONMOUSEUP);
      }

      @Override
      public void onBrowserEvent(Event event)
      {
         if (!command.isEnabled())
         {
            return;
         }

         switch (DOM.eventGetType(event))
         {
            case Event.ONMOUSEOVER :
               onMouseOver();
               break;

            case Event.ONMOUSEOUT :
               onMouseOut();
               break;

            case Event.ONMOUSEDOWN :
               if (event.getButton() != Event.BUTTON_LEFT)
               {
                  return;
               }

               onMouseDown();
               break;

            case Event.ONMOUSEUP :
               onMouseUp();
               break;
         }
      }

   }

   public void updateControlPrompt(String prompt)
   {
      simplePanel.setTitle(prompt);
   }

   public void updateControlTitle(String title)
   {
   }

   public void updateControlIcon(String icon)
   {
      setIcon(icon);
      
      Image image = getImage();

      buttonPanel.clear();
      buttonPanel.add(image);

      buttonPanel.setStyleName(Style.BUTTON);
   }

   public void updateControlSelectionState(boolean selected)
   {
      if (selected)
      {
         if (overed)
         {
            buttonPanel.setStyleName(Style.BUTTON_SELECTED_OVER);
         }
         else
         {
            buttonPanel.setStyleName(Style.BUTTON_SELECTED);
         }
      }
      else
      {
         if (overed)
         {
            buttonPanel.setStyleName(Style.BUTTON_OVER);
         }
         else
         {
            buttonPanel.setStyleName(Style.BUTTON);
         }
      }

   }

}
