/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.toolbar.component;

import org.exoplatform.gwtframework.ui.client.component.ExoStyle;
import org.exoplatform.gwtframework.ui.client.component.command.TextInputControl;
import org.exoplatform.gwtframework.ui.client.component.command.TextInputControlStateListener;
import org.exoplatform.gwtframework.ui.client.component.toolbar.GWTToolbar;

import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class ToolbarTextInput extends Composite implements ToolbarControl, TextInputControlStateListener
{

   public static interface Style
   {

      static final String TEXT_PANEL_LEFT = "exo-toolbar16TextPanel_Left";

      static final String TEXT_PANEL_LEFT_HIDDEN = "exo-toolbar16TextPanel_LeftHidden";

      static final String TEXT_PANEL_RIGHT = "exo-toolbar16TextPanel_Right";

      static final String TEXT_PANEL_RIGHT_HIDDEN = "exo-toolbar16TextPanel_RightHidden";

      static final String TEXT_TABLE = "exo-toolbar16TextTable";

      static final String TEXT_LEFT = "exo-toolbar16TextLeft";

      static final String TEXT_LEFT_DOWN = "exo-toolbar16TextLeftDown";

      static final String TEXT_AREA = "exo-toolbar16TextArea";

      static final String TEXT_AREA_DOWN = "exo-toolbar16TextAreaDown";

      static final String TEXT_INPUT_FIELD = "exo-toolbar16TextInputField";

      static final String TEXT_INPUT_FIELD_DOWN = "exo-toolbar16TextInputFieldDown";

      static final String TEXT_DELIMITER = "exo-toolbar16TextDelimiter";

      static final String TEXT_DELIMITER_DOWN = "exo-toolbar16TextDelimiterDown";

      static final String TEXT_BUTTON = "exo-toolbar16TextButton";

      static final String TEXT_BUTTON_DOWN = "exo-toolbar16TextButtonDown";

      static final String TEXT_BUTTON_PANEL = "exo-toolbar16TextButtonPanel";

      static final String TEXT_BUTTON_ICON = "exo-toolbar16TextButtonIcon";

      static final String TEXT_BUTTON_ICON_DISABLED = "exo-toolbar16TextButtonIconDisabled";

      static final String TEXT_RIGHT = "exo-toolbar16TextRight";

      static final String TEXT_RIGHT_DOWN = "exo-toolbar16TextRightDown";

   }

   private final static String DISABLED_SUFFIX = "_Disabled";

   private HandlerManager eventBus;

   private TextInputControl command;

   private boolean rightDocking;

   private GWTToolbar toolbar;

   private SimplePanel simplePanel;

   private Grid grid;

   private TextBox textBox;

   private boolean down = false;

   private String iconNormal;

   private String iconDisabled;

   private ButtonPanel button;

   public ToolbarTextInput(HandlerManager eventBus, TextInputControl command, boolean rightDocking, GWTToolbar toolbar)
   {
      this.eventBus = eventBus;
      this.command = command;
      this.rightDocking = rightDocking;
      this.toolbar = toolbar;

      simplePanel = new SimplePanel();
      updateVisibility();
      initWidget(simplePanel);

      setIcon(command.getIcon());

      createToolbarTable();

      command.getStateListeners().add(this);
   }

   private void setIcon(String icon)
   {
      if (command.getIcon() == null)
      {
         return;
      }

      iconNormal = icon;
      iconDisabled = iconNormal.substring(0, iconNormal.lastIndexOf("."));
      iconDisabled += DISABLED_SUFFIX;
      iconDisabled += iconNormal.substring(iconNormal.lastIndexOf("."));
   }

   private void createToolbarTable()
   {
      grid = new Grid(1, 5);
      grid.setStyleName(Style.TEXT_TABLE);
      grid.setCellPadding(0);
      grid.setCellSpacing(0);
      grid.setBorderWidth(0);
      simplePanel.add(grid);

      grid.setHTML(0, 0, ExoStyle.getBlankImage());

      textBox = new TextBox();
      textBox.addKeyUpHandler(keyUpHandler);
      grid.setWidget(0, 1, textBox);

      grid.setHTML(0, 2, ExoStyle.getBlankImage());

      button = new ButtonPanel();
      button.setTitle(command.getPrompt());
      grid.setWidget(0, 3, button);

      grid.setHTML(0, 4, ExoStyle.getBlankImage());

      updateStyles();
   }

   private KeyUpHandler keyUpHandler = new KeyUpHandler()
   {
      public void onKeyUp(KeyUpEvent event)
      {
         if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER)
         {
            sendEvent();
         }
      }
   };

   private void updateVisibility()
   {
      if (command.isVisible())
      {
         simplePanel.setStyleName(rightDocking ? Style.TEXT_PANEL_RIGHT : Style.TEXT_PANEL_LEFT);
         DOM.setStyleAttribute(simplePanel.getElement(), "width", "" + command.getSize() + "px");
      }
      else
      {
         simplePanel.setStyleName(rightDocking ? Style.TEXT_PANEL_RIGHT_HIDDEN : Style.TEXT_PANEL_LEFT_HIDDEN);
         DOM.setStyleAttribute(simplePanel.getElement(), "width", "0px");
      }
   }

   private void updateStyles()
   {
      if (command.isEnabled())
      {
         if (down)
         {
            grid.getCellFormatter().setStyleName(0, 0, Style.TEXT_LEFT_DOWN);
            grid.getCellFormatter().setStyleName(0, 1, Style.TEXT_AREA_DOWN);
            DOM.removeElementAttribute(textBox.getElement(), "disabled");
            textBox.setStyleName(Style.TEXT_INPUT_FIELD_DOWN);
            grid.getCellFormatter().setStyleName(0, 2, Style.TEXT_DELIMITER_DOWN);
            grid.getCellFormatter().setStyleName(0, 3, Style.TEXT_BUTTON_DOWN);
            grid.getCellFormatter().setStyleName(0, 4, Style.TEXT_RIGHT_DOWN);
         }
         else
         {
            grid.getCellFormatter().setStyleName(0, 0, Style.TEXT_LEFT);
            grid.getCellFormatter().setStyleName(0, 1, Style.TEXT_AREA);
            textBox.setStyleName(Style.TEXT_INPUT_FIELD);
            DOM.removeElementAttribute(textBox.getElement(), "disabled");
            grid.getCellFormatter().setStyleName(0, 2, Style.TEXT_DELIMITER);
            grid.getCellFormatter().setStyleName(0, 3, Style.TEXT_BUTTON);
            grid.getCellFormatter().setStyleName(0, 4, Style.TEXT_RIGHT);
         }
      }
      else
      {
         grid.getCellFormatter().setStyleName(0, 0, Style.TEXT_LEFT);
         grid.getCellFormatter().setStyleName(0, 1, Style.TEXT_AREA);
         textBox.setStyleName(Style.TEXT_INPUT_FIELD);
         DOM.setElementAttribute(textBox.getElement(), "disabled", "disabled");
         grid.getCellFormatter().setStyleName(0, 2, Style.TEXT_DELIMITER);
         grid.getCellFormatter().setStyleName(0, 3, Style.TEXT_BUTTON);
         grid.getCellFormatter().setStyleName(0, 4, Style.TEXT_RIGHT);
      }

      int width = command.getSize() - 34;
      textBox.setWidth("" + width + "px");
   }

   protected void onMouseDown()
   {
      down = true;
      updateStyles();
   }

   protected void onMouseUp()
   {
      if (!down)
      {
         return;
      }

      down = false;
      updateStyles();
      sendEvent();
   }

   protected void onMouseOut()
   {
      down = false;
      updateStyles();
   }

   private void sendEvent()
   {
      if (command.getEvent() != null)
      {
         command.getEvent().setText(textBox.getValue());
         eventBus.fireEvent(command.getEvent());
      }
   }

   private class ButtonPanel extends Composite
   {

      private SimplePanel buttonPanel = new SimplePanel();

      public ButtonPanel()
      {
         buttonPanel.setStyleName(Style.TEXT_BUTTON_PANEL);
         initWidget(buttonPanel);
         updateIcon();

         sinkEvents(Event.ONMOUSEOUT | Event.ONMOUSEDOWN | Event.ONMOUSEUP);
      }

      public void updateIcon()
      {
         Image image = null;

         if (command.isEnabled())
         {
            if (command.getNormalImage() != null)
            {
               image = new Image(command.getNormalImage());
            }
            else
            {
               image = new Image(command.getIcon());
            }

            //            String html = "<img class=\"" + Style.TEXT_BUTTON_ICON + "\" src=\"" + iconNormal + "\">";
            //            DOM.setInnerHTML(buttonPanel.getElement(), html);

            image.setStyleName(Style.TEXT_BUTTON_ICON);

         }
         else
         {

            if (command.getDisabledImage() != null)
            {
               image = new Image(command.getDisabledImage());
            }
            else
            {
               image = new Image(command.getIcon());
            }

            //            String html = "<img class=\"" + Style.TEXT_BUTTON_ICON_DISABLED + "\" src=\"" + iconDisabled + "\">";
            //            DOM.setInnerHTML(buttonPanel.getElement(), html);

            image.setStyleName(Style.TEXT_BUTTON_ICON_DISABLED);
         }

         buttonPanel.clear();
         buttonPanel.add(image);
      }

      @Override
      public void onBrowserEvent(Event event)
      {
         if (!command.isEnabled())
         {
            return;
         }

         switch (DOM.eventGetType(event))
         {
            case Event.ONMOUSEOUT :
               onMouseOut();
               break;

            case Event.ONMOUSEDOWN :
               if (event.getButton() != Event.BUTTON_LEFT)
               {
                  return;
               }

               onMouseDown();
               break;

            case Event.ONMOUSEUP :
               onMouseUp();
               break;
         }
      }

   }

   public void updateControlText(String text)
   {
      textBox.setValue(text);
   }

   public void updateControlEnabling(boolean enabled)
   {
      down = false;
      updateStyles();
      button.updateIcon();
   }

   public void updateControlPrompt(String prompt)
   {
      button.setTitle(prompt);
   }

   public void updateControlVisibility(boolean visible)
   {
      updateVisibility();
      toolbar.checkDelimiters();
   }

   public void updateControlIcon(String icon)
   {
      setIcon(icon);
      button.updateIcon();
   }

   public boolean isControlVisible()
   {
      return command.isVisible();
   }

}
