/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.transaction.xa.XAException;

/**
 * Provides XAException functionality with constructor for errorcode and message.
 * 
 * @author <a href="mailto:peter.nedonosko@exoplatform.com">Peter Nedonosko</a>
 * @version $Id: XASessionException.java 1518 2010-01-20 23:33:30Z sergiykarpenko $
 *  */
public class XASessionException extends XAException
{

   /**
    * serialVersionUID.
    */
   private static final long serialVersionUID = -1853702973389878895L;

   public XASessionException()
   {
      super();
   }

   public XASessionException(int errcode)
   {
      super(errcode);
   }

   public XASessionException(String s)
   {
      super(s);
   }
   
   public XASessionException(String s, int errorCode)
   {
      super(s);
      this.errorCode = errorCode;
   }
}
