/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileInputStream;

/**
 * Created by The eXo Platform SAS.
 * 
 * @author Gennady Azarenkov
 * @version $Id: Probe.java 1595 2010-01-27 16:38:01Z pnedonosko $
 */

public class Probe extends Thread
{

   private File file;

   private int len = 0;

   public Probe()
   {
   }

   public Probe(File file)
   {
      super();
      this.file = file;
   }

   public void run()
   {
      System.out.println("Thread started " + this.getName());
      try
      {
         FileInputStream is = new FileInputStream(file);
         while (is.read() > 0)
         {
            len++;
         }

      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      System.out.println("Thread finished " + this.getName() + " read: " + len);
   }

   public int getLen()
   {
      return len;
   }
}
