/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;

public class JDOClassDescriptor
extends ClassDescriptorImpl {
    private String _tableName;
    private ClassDescriptor _depends;
    private final KeyGeneratorDescriptor _keyGenDesc;
    private final String _cacheType;
    private final int _cacheParam;
    private String[] _idnames;

    public JDOClassDescriptor(ClassDescriptor clsDesc, String tableName, KeyGeneratorDescriptor keyGenDesc, String cacheType, int cacheParam) throws MappingException {
        super(clsDesc.getJavaClass(), clsDesc.getFields(), clsDesc instanceof ClassDescriptorImpl ? ((ClassDescriptorImpl)clsDesc).getIdentities() : null, clsDesc.getExtends(), clsDesc instanceof ClassDescriptorImpl ? ((ClassDescriptorImpl)clsDesc).getDepends() : null, clsDesc.getAccessMode());
        if (tableName == null) {
            throw new IllegalArgumentException("Argument 'tableName' is null");
        }
        if (this.getIdentity() == null) {
            throw new MappingException("mapping.noIdentity", this.getJavaClass().getName());
        }
        if (!(this.getIdentity() instanceof JDOFieldDescriptor)) {
            throw new IllegalArgumentException("Identity field must be of type JDOFieldDescriptor");
        }
        if (this.getExtends() != null && !(this.getExtends() instanceof JDOClassDescriptor)) {
            throw new IllegalArgumentException("Extended class does not have a JDO descriptor");
        }
        this._tableName = tableName;
        this._keyGenDesc = keyGenDesc;
        this._cacheType = cacheType;
        this._cacheParam = cacheParam;
        if (clsDesc instanceof ClassDescriptorImpl) {
            this._depends = ((ClassDescriptorImpl)clsDesc).getDepends();
        }
        this._idnames = new String[this._identities.length];
        int i = 0;
        while (i < this._idnames.length) {
            String[] sqlNames = ((JDOFieldDescriptor)this._identities[i]).getSQLName();
            if (sqlNames == null) {
                throw new MappingException("mapping.noSqlName", this._identities[i].getFieldName(), this.getJavaClass().getName());
            }
            this._idnames[i] = sqlNames[0];
            ++i;
        }
    }

    public String getTableName() {
        return this._tableName;
    }

    public ClassDescriptor getDepends() {
        return this._depends;
    }

    public String getCacheType() {
        return this._cacheType;
    }

    public int getCacheParam() {
        return this._cacheParam;
    }

    public JDOFieldDescriptor getField(String name) {
        JDOFieldDescriptor field = null;
        int i = 0;
        while (i < this._fields.length) {
            if (this._fields[i] instanceof JDOFieldDescriptor && this._fields[i].getFieldName().equals(name)) {
                field = (JDOFieldDescriptor)this._fields[i];
                break;
            }
            ++i;
        }
        if (field == null) {
            int i2 = 0;
            while (i2 < this._identities.length) {
                if (this._identities[i2] instanceof JDOFieldDescriptor && this._identities[i2].getFieldName().equals(name)) {
                    field = (JDOFieldDescriptor)this._identities[i2];
                }
                ++i2;
            }
        }
        return field;
    }

    public KeyGeneratorDescriptor getKeyGeneratorDescriptor() {
        return this._keyGenDesc;
    }

    public String[] getIdentityColumnNames() {
        return this._idnames;
    }

    public String toString() {
        return super.toString() + " AS " + this._tableName;
    }
}

