/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.Var;

class CallFrame {
    protected Interp interp;
    NamespaceCmd.Namespace ns;
    boolean isProcCallFrame;
    TclObject[] objv;
    protected CallFrame caller;
    protected CallFrame callerVar;
    protected int level;
    protected Hashtable varTable;

    CallFrame(Interp interp) {
        this.interp = interp;
        this.ns = interp.globalNs;
        this.varTable = new Hashtable();
        this.caller = null;
        this.callerVar = null;
        this.objv = null;
        this.level = 0;
        this.isProcCallFrame = true;
    }

    CallFrame(Interp interp, Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        this(interp);
        try {
            this.chain(procedure, tclObjectArray);
        }
        catch (TclException tclException) {
            this.dispose();
            throw tclException;
        }
    }

    void chain(Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        this.ns = procedure.ns;
        this.objv = tclObjectArray;
        this.level = this.interp.varFrame == null ? 1 : this.interp.varFrame.level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int n = procedure.argList.length;
        if (!procedure.isVarArgs && tclObjectArray.length - 1 > n) {
            throw new TclException(this.interp, "called \"" + tclObjectArray[0] + "\" with too many arguments");
        }
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            TclObject tclObject = procedure.argList[n2][0];
            TclObject tclObject2 = null;
            if (n2 == n - 1 && procedure.isVarArgs) {
                tclObject2 = TclList.newInstance();
                tclObject2.preserve();
                int n4 = n3;
                while (n4 < tclObjectArray.length) {
                    TclList.append(this.interp, tclObject2, tclObjectArray[n4]);
                    ++n4;
                }
                this.interp.setVar(tclObject, tclObject2, 0);
                tclObject2.release();
            } else {
                if (n3 < tclObjectArray.length) {
                    tclObject2 = tclObjectArray[n3];
                } else if (procedure.argList[n2][1] != null) {
                    tclObject2 = procedure.argList[n2][1];
                } else {
                    throw new TclException(this.interp, "no value given for parameter \"" + tclObject + "\" to \"" + tclObjectArray[0] + "\"");
                }
                this.interp.setVar(tclObject, tclObject2, 0);
            }
            ++n2;
            ++n3;
        }
    }

    static boolean exists(Interp interp, String string) {
        try {
            Var[] varArray = Var.lookupVar(interp, string, null, 0, "lookup", false, false);
            if (varArray == null) {
                return false;
            }
            return !varArray[0].isVarUndefined();
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    Vector getVarNames() {
        Vector<String> vector = new Vector<String>();
        if (this.varTable == null) {
            return vector;
        }
        Enumeration enumeration = this.varTable.elements();
        while (enumeration.hasMoreElements()) {
            Var var = (Var)enumeration.nextElement();
            if (var.isVarUndefined()) continue;
            vector.addElement(var.hashKey);
        }
        return vector;
    }

    Vector getLocalVarNames() {
        Vector<String> vector = new Vector<String>();
        if (this.varTable == null) {
            return vector;
        }
        Enumeration enumeration = this.varTable.elements();
        while (enumeration.hasMoreElements()) {
            Var var = (Var)enumeration.nextElement();
            if (var.isVarUndefined() || var.isVarLink()) continue;
            vector.addElement(var.hashKey);
        }
        return vector;
    }

    static int getFrame(Interp interp, String string, CallFrame[] callFrameArray) throws TclException {
        CallFrame callFrame;
        int n;
        int n2;
        int n3 = 1;
        int n4 = n2 = interp.varFrame == null ? 0 : interp.varFrame.level;
        if (string.length() > 0 && string.charAt(0) == '#') {
            n = Util.getInt(interp, string.substring(1));
            if (n < 0) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        } else if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            n = Util.getInt(interp, string);
            n = n2 - n;
        } else {
            n = n2 - 1;
            n3 = 0;
        }
        if (n == 0) {
            callFrame = null;
        } else {
            callFrame = interp.varFrame;
            while (callFrame != null) {
                if (callFrame.level == n) break;
                callFrame = callFrame.callerVar;
            }
            if (callFrame == null) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        }
        callFrameArray[0] = callFrame;
        return n3;
    }

    protected void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        if (this.varTable != null) {
            Var.deleteVars(this.interp, this.varTable);
        }
        this.varTable = null;
    }
}

