/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.editor.api;

import java.util.List;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class EditorConfiguration
{

   private String id = String.valueOf(this.hashCode());

   private boolean readOnly = false;

   private boolean lineNumbers = false;

   private String mimeType;
   
   private List<String> hotKeyList;

   public EditorConfiguration(String mimeType)
   {
      this.mimeType = mimeType;
   }

   public String getId()
   {
      return id;
   }

   public boolean isReadOnly()
   {
      return readOnly;
   }

   public void setReadOnly(boolean readOnly)
   {
      this.readOnly = readOnly;
   }

   public boolean isLineNumbers()
   {
      return lineNumbers;
   }

   public void setLineNumbers(boolean lineNumbers)
   {
      this.lineNumbers = lineNumbers;
   }

   public String getMimeType()
   {
      return mimeType;
   }

   public void setMimeType(String mimeType)
   {
      this.mimeType = mimeType;
   }

   public void setHotKeyList(List<String> hotKeyList)
   {
      this.hotKeyList = hotKeyList;
   }

   public List<String> getHotKeyList()
   {
      return this.hotKeyList;
   }
}
