/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.editor.api;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public abstract class GWTTextEditor extends Composite implements TextEditor
{

   protected HandlerManager eventBus;

   private AbsolutePanel editorPanel;

   protected EditorConfiguration configuration;

   public GWTTextEditor(HandlerManager eventBus, EditorConfiguration configuration)
   {
      this.eventBus = eventBus;
      this.configuration = configuration;

      editorPanel = new AbsolutePanel();
      DOM.setElementAttribute(editorPanel.getElement(), "id", "my-generated-id-" + Random.nextInt());
      initWidget(editorPanel);
   }

   public AbsolutePanel editorPanel()
   {
      return editorPanel;
   }

   public String getEditorId()
   {
      return configuration.getId();
   }

}
