/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.command.builder;

import org.exoplatform.gwtframework.ui.client.component.command.StatusTextControl;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class StatusTextCommandBuilder
{

   private StatusTextControl command;

   protected StatusTextCommandBuilder(StatusTextControl command)
   {
      this.command = command;
   }

   public static StatusTextCommandBuilder newCommand(String id)
   {
      return new StatusTextCommandBuilder(new StatusTextControl(id));
   }

   public StatusTextControl create()
   {
      return command;
   }

   public StatusTextCommandBuilder icon(String icon)
   {
      command.setIcon(icon);
      return this;
   }

   public StatusTextCommandBuilder text(String text)
   {
      command.setText(text);
      return this;
   }

   public StatusTextCommandBuilder show()
   {
      command.setVisible(true);
      return this;
   }

   public StatusTextCommandBuilder hide()
   {
      command.setVisible(false);
      return this;
   }

   public StatusTextCommandBuilder size(int size)
   {
      command.setSize(size);
      return this;
   }

   public StatusTextCommandBuilder fireEventOnSingleClick(boolean fireEventOnSingleClick)
   {
      command.setFireEventOnSingleClick(fireEventOnSingleClick);
      return this;
   }

   public StatusTextCommandBuilder event(GwtEvent<?> event)
   {
      command.setEvent(event);
      return this;
   }

}
