/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.menu.event;

import org.exoplatform.gwtframework.ui.client.component.command.SimpleControl;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class GWTMenuItemSelectedEvent extends GwtEvent<GWTMenuItemSelectedHandler>
{

   public static final GwtEvent.Type<GWTMenuItemSelectedHandler> TYPE = new GwtEvent.Type<GWTMenuItemSelectedHandler>();

   private SimpleControl control;

   public GWTMenuItemSelectedEvent(SimpleControl control)
   {
      this.control = control;
   }

   public SimpleControl getControl()
   {
      return control;
   }

   @Override
   protected void dispatch(GWTMenuItemSelectedHandler handler)
   {
      handler.onGWTMenuItemSelected(this);
   }

   @Override
   public com.google.gwt.event.shared.GwtEvent.Type<GWTMenuItemSelectedHandler> getAssociatedType()
   {
      return TYPE;
   }

}
