/**
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 *
 */
package org.exoplatform.gwtframework.ui.client.component.statusbar.component;

import org.exoplatform.gwtframework.ui.client.component.ExoStyle;
import org.exoplatform.gwtframework.ui.client.component.command.StatusTextAlign;
import org.exoplatform.gwtframework.ui.client.component.command.StatusTextControl;
import org.exoplatform.gwtframework.ui.client.component.command.StatusTextControlStateListener;

import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gavrikvetal@gmail.com">Vitaliy Gulyy</a>
 * @version $
 */

public class StatusBarTextControl extends Composite implements StatusTextControlStateListener
{

   public static interface Style
   {

      static final String PANEL = "exo-statusText-panel";

      static final String TABLE = "exo-statusText-table";

      static final String TABLE_LEFT = "exo-statusText-table-left";

      static final String TABLE_LEFT_OVER = "exo-statusText-table-left-over";

      static final String TABLE_LEFT_DOWN = "exo-statusText-table-left-down";

      static final String TABLE_RIGHT = "exo-statusText-table-right";

      static final String TABLE_RIGHT_OVER = "exo-statusText-table-right-over";

      static final String TABLE_RIGHT_DOWN = "exo-statusText-table-right-down";

      static final String TABLE_MIDDLE = "exo-statusText-table-middle";

      static final String TABLE_MIDDLE_OVER = "exo-statusText-table-middle-over";

      static final String TABLE_MIDDLE_DOWN = "exo-statusText-table-middle-down";

   }

   private HandlerManager eventBus;

   private StatusPanel flowPanel = new StatusPanel();

   private StatusTextControl control;

   private Grid textGrid;

   public StatusBarTextControl(HandlerManager eventBus, StatusTextControl control)
   {
      this.control = control;
      this.eventBus = eventBus;

      initWidget(flowPanel);
      flowPanel.setStyleName(Style.PANEL);

      createControlTable();

      updateStatusText(control.getText());
      control.getStateListeners().add(this);
   }

   public void setWidth(String width)
   {
      super.setWidth(width);
   }

   private void createControlTable()
   {
      textGrid = new Grid(1, 3);

      textGrid.setStyleName(Style.TABLE);
      textGrid.setBorderWidth(0);
      textGrid.setCellPadding(0);
      textGrid.setCellSpacing(0);

      textGrid.setHTML(0, 0, ExoStyle.getBlankImage());
      textGrid.setHTML(0, 2, ExoStyle.getBlankImage());

      if (control.getTextAlignment() == StatusTextAlign.LEFT)
      {
         DOM.setStyleAttribute(textGrid.getCellFormatter().getElement(0, 1), "textAlign", "left");
      }
      else if (control.getTextAlignment() == StatusTextAlign.MIDDLE)
      {
         DOM.setStyleAttribute(textGrid.getCellFormatter().getElement(0, 1), "textAlign", "center");
      }
      else
      {
         DOM.setStyleAttribute(textGrid.getCellFormatter().getElement(0, 1), "textAlign", "right");
      }

      flowPanel.add(textGrid);

      setNormal();
   }

   private void setNormal()
   {
      textGrid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT);
      textGrid.getCellFormatter().setStyleName(0, 1, Style.TABLE_MIDDLE);
      textGrid.getCellFormatter().setStyleName(0, 2, Style.TABLE_RIGHT);
   }

   private void setOver()
   {
      textGrid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT_OVER);
      textGrid.getCellFormatter().setStyleName(0, 1, Style.TABLE_MIDDLE_OVER);
      textGrid.getCellFormatter().setStyleName(0, 2, Style.TABLE_RIGHT_OVER);
   }

   private void setDown()
   {
      textGrid.getCellFormatter().setStyleName(0, 0, Style.TABLE_LEFT_DOWN);
      textGrid.getCellFormatter().setStyleName(0, 1, Style.TABLE_MIDDLE_DOWN);
      textGrid.getCellFormatter().setStyleName(0, 2, Style.TABLE_RIGHT_DOWN);
   }

   public void updateStatusText(String text)
   {
      textGrid.setHTML(0, 1, text);
   }

   public void updateControlEnabling(boolean enabled)
   {
   }

   public void updateControlIcon(String icon)
   {
   }

   public void updateControlPrompt(String prompt)
   {
   }

   public void updateControlVisibility(boolean visible)
   {
   }

   protected void onMouseOver()
   {
      if (control.getEvent() == null)
      {
         return;
      }

      setOver();

      DOM.setStyleAttribute(textGrid.getElement(), "cursor", "pointer");
   }

   protected void onMouseOut()
   {
      setNormal();
      DOM.setStyleAttribute(textGrid.getElement(), "cursor", "default");
   }

   protected void onMouseDown()
   {
      if (control.getEvent() == null)
      {
         return;
      }

      setDown();
   }

   protected void onMouseUp()
   {
      if (control.getEvent() == null)
      {
         return;
      }

      setOver();
   }

   protected void onMouseClick()
   {
      if (control.getEvent() == null)
      {
         return;
      }

      if (control.isFireEventOnSingleClick())
      {
         eventBus.fireEvent(control.getEvent());
      }
   }

   protected void onMouseDClick()
   {
      if (control.getEvent() == null)
      {
         return;
      }

      if (control.isFireEventOnSingleClick())
      {
         return;
      }

      if (control.getEvent() != null)
      {
         eventBus.fireEvent(control.getEvent());
      }
   }

   private class StatusPanel extends FlowPanel
   {

      public StatusPanel()
      {
         sinkEvents(Event.ONDBLCLICK | Event.ONMOUSEOVER | Event.ONMOUSEOUT | Event.ONCLICK | Event.ONMOUSEDOWN
            | Event.ONMOUSEUP);
      }

      @Override
      public void onBrowserEvent(Event event)
      {
         switch (DOM.eventGetType(event))
         {
            case Event.ONDBLCLICK :
               onMouseDClick();
               break;

            case Event.ONMOUSEOVER :
               onMouseOver();
               break;

            case Event.ONMOUSEOUT :
               onMouseOut();
               break;

            case Event.ONCLICK :
               onMouseClick();
               break;

            case Event.ONMOUSEDOWN :
               onMouseDown();
               break;

            case Event.ONMOUSEUP :
               onMouseUp();
               break;
         }
      }

   }

}
